/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Character;
import classes.Item;
import classes.Monster;
import classes.Ruestung;
import classes.Waffe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tools.HelpMethods;
import ui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPanel
extends JPanel {
    private static final long serialVersionUID = -4514097929839220207L;
    JList listCharacter = new JList();
    String[] listContent = null;
    public int aktRow = 0;
    public Font font = null;
    public static String fontName = null;
    private static final int FIRST_ROW_TEXTAREA = 18;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_INV_WAFFEN = 1;
    public static final int STATE_INV_RUESTUNGEN = 2;
    public static final int STATE_INV_ITEMS = 3;
    public int state = 0;

    public TextPanel() {
        GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = g.getAvailableFontFamilyNames();
        int i = 0;
        while (i < fonts.length) {
            if (fonts[i].equals("Lucida Console")) {
                fontName = "Lucida Console";
            }
            ++i;
        }
        if (fontName == null) {
            i = 0;
            while (i < fonts.length) {
                if (fonts[i].equals("Monospaced")) {
                    fontName = "Monospaced";
                }
                ++i;
            }
        }
        if (fontName == null) {
            fontName = "Courier";
        }
        this.font = new Font(fontName, 1, 16);
        this.listCharacter.setFont(this.font);
        this.listContent = new String[]{"                            ", "                            ", "                            ", "                            ", "----------------------------", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "----------------------------", "                            ", "                            ", "                            ", "                            ", "----------------------------", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            ", "                            "};
        this.listCharacter.setListData(this.listContent);
        this.listCharacter.setBackground(Color.BLACK);
        this.listCharacter.setForeground(Color.YELLOW);
        this.listCharacter.setBorder(new LineBorder(Color.darkGray));
        this.listCharacter.setFixedCellHeight(this.font.getSize() + 1);
        this.listCharacter.setFocusable(false);
        this.listCharacter.setSelectedIndex(1);
        this.listCharacter.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TextPanel.this.doSelection();
            }
        });
        this.setLayout(new BorderLayout());
        this.add("North", this.listCharacter);
        this.setBackground(this.listCharacter.getBackground());
    }

    private void doSelection() {
        int row = this.listCharacter.getSelectedIndex();
        this.listCharacter.clearSelection();
        if (row < 4) {
            this.characterSelected(row);
        }
        if (row >= 18 && this.state != 0) {
            Character chr;
            int textRow = row - 18 - 1;
            if (this.state == 1 && MainWindow.inventoryWaffen.size() > textRow && textRow >= 0) {
                chr = MainWindow.characters[MainWindow.selectedSurfaceCharacter];
                Waffe wf = MainWindow.inventoryWaffen.get(textRow);
                if (MainWindow.professions[chr.profession].waffenTyp == wf.typ) {
                    this.clearTextArea();
                    this.writeText(MainWindow.screenTexts.get("new_weapon_for"));
                    this.writeText(String.valueOf(chr.name) + " :");
                    this.writeText(wf.name);
                    Waffe oldWf = HelpMethods.getWaffe(MainWindow.professions[chr.profession].waffenTyp, chr.waffe);
                    MainWindow.characters[MainWindow.selectedSurfaceCharacter].waffe = wf.id;
                    if (oldWf.typ == 0) {
                        MainWindow.inventoryWaffen.remove(textRow);
                    } else {
                        MainWindow.inventoryWaffen.set(textRow, oldWf);
                    }
                    this.updateCharDetail(MainWindow.selectedSurfaceCharacter);
                } else {
                    this.clearTextArea();
                    this.writeText(chr.name);
                    this.writeText(String.valueOf(MainWindow.screenTexts.get("can_not_use_weapon")) + " :");
                    this.writeText(wf.name);
                }
            }
            if (this.state == 2 && MainWindow.inventoryRuestung.size() > textRow && textRow >= 0) {
                chr = MainWindow.characters[MainWindow.selectedSurfaceCharacter];
                Ruestung rs = MainWindow.inventoryRuestung.get(textRow);
                if (MainWindow.professions[chr.profession].ruestung >= rs.id) {
                    this.clearTextArea();
                    this.writeText(MainWindow.screenTexts.get("new_armor_for"));
                    this.writeText(String.valueOf(chr.name) + " :");
                    this.writeText(rs.name);
                    Ruestung oldRs = MainWindow.ruestungen[chr.ruestung];
                    MainWindow.characters[MainWindow.selectedSurfaceCharacter].ruestung = rs.id;
                    if (oldRs.id == 0) {
                        MainWindow.inventoryRuestung.remove(textRow);
                    } else {
                        MainWindow.inventoryRuestung.set(textRow, oldRs);
                    }
                    this.updateCharDetail(MainWindow.selectedSurfaceCharacter);
                } else {
                    this.clearTextArea();
                    this.writeText(chr.name);
                    this.writeText(String.valueOf(MainWindow.screenTexts.get("can_not_use_armor")) + " :");
                    this.writeText(rs.name);
                }
            }
            this.state = 0;
        }
    }

    public void setFontSize(int size) {
        this.font = new Font(fontName, 1, size);
        this.listCharacter.setFont(this.font);
        this.listCharacter.setFixedCellHeight(this.font.getSize() + 1);
        this.updateUI();
    }

    public void updateCharDetail(int character) {
        Character ch = MainWindow.characters[character];
        this.listContent[5] = this.formatListContent(ch.name, MainWindow.professions[ch.profession].name);
        this.listContent[6] = this.formatListContent(MainWindow.screenTexts.get("level"), ch.level + 1 + "." + MainWindow.professions[ch.profession].level[ch.level]);
        int wfTyp = MainWindow.professions[ch.profession].waffenTyp;
        int wfId = ch.waffe;
        this.listContent[7] = this.formatListContent(MainWindow.screenTexts.get("weapon"), HelpMethods.getWaffe((int)wfTyp, (int)wfId).name);
        this.listContent[8] = this.formatListContent(MainWindow.screenTexts.get("armor"), MainWindow.ruestungen[ch.ruestung].name);
        this.listContent[9] = this.formatListContent(MainWindow.screenTexts.get("strength"), "" + ch.st);
        this.listContent[10] = this.formatListContent(MainWindow.screenTexts.get("dextery"), "" + ch.dx);
        this.listContent[11] = this.formatListContent(MainWindow.screenTexts.get("magic"), "" + ch.aktMg);
        this.listContent[12] = this.formatListContent(MainWindow.screenTexts.get("experience"), "" + ch.exp);
        this.listCharacter.setListData(this.listContent);
        this.doLayout();
    }

    public boolean characterSelected(int row) {
        if (row > 3 || row < 0) {
            return false;
        }
        if (MainWindow.characters[row].zustand == 'D') {
            return false;
        }
        MainWindow.selectedSurfaceCharacter = row;
        this.updateCharDetail(row);
        return true;
    }

    public void updateGoods(int gold, int food, int keys, int torches) {
        this.listContent[13] = this.formatListContent(MainWindow.screenTexts.get("gold"), "" + gold);
        this.listContent[14] = this.formatListContent(MainWindow.screenTexts.get("food"), "" + food);
        this.listContent[15] = this.formatListContent(MainWindow.screenTexts.get("keys"), "" + keys);
        this.listContent[16] = this.formatListContent(MainWindow.screenTexts.get("torches"), "" + torches);
    }

    public void updateCharacters() {
        int i = 0;
        while (i < MainWindow.characters.length) {
            Character ch = MainWindow.characters[i];
            String health = String.valueOf(String.valueOf(ch.aktHp)) + " " + ch.zustand;
            this.listContent[i] = this.formatListContent(ch.name, health);
            ++i;
        }
        this.listCharacter.setListData(this.listContent);
        this.updateUI();
    }

    public void writeText(String text) {
        this.writeText(text, this.aktRow);
    }

    public void writeText(String text, String[] params) {
        String locText = text;
        int i = 0;
        while (i < params.length) {
            locText = locText.replace("[param" + (i + 1) + "]", params[i]);
            ++i;
        }
        this.writeText(locText);
    }

    public void writeText(String text, int row, String[] params) {
        String locText = text;
        int i = 0;
        while (i < params.length) {
            locText = locText.replace("[param" + (i + 1) + "]", params[i]);
            ++i;
        }
        this.writeText(locText, row);
    }

    public void writeText(String text, int row) {
        String[] arText = text.split("#");
        int zeile = row + 18;
        while (zeile < this.listContent.length) {
            if (zeile - 18 - row < arText.length) {
                this.listContent[zeile] = arText[zeile - 18 - row];
                if (this.listContent[zeile].length() > 27) {
                    this.listContent[zeile] = this.listContent[zeile].substring(0, 27);
                }
                ++this.aktRow;
            } else {
                this.listContent[zeile] = " ";
            }
            ++zeile;
        }
        this.updateUI();
    }

    public String formatListContent(String value1, String value2) {
        return this.formatListContent(value1, value2, this.listContent[0].length());
    }

    public String formatListContent(String value1, String value2, int endTab) {
        String result = "";
        endTab -= value2.length();
        result = value1;
        int i = value1.length();
        while (i < endTab) {
            result = String.valueOf(result) + " ";
            ++i;
        }
        result = String.valueOf(result) + value2;
        return result;
    }

    public void clearTextArea() {
        this.state = 0;
        this.aktRow = 0;
        int zeile = 18;
        while (zeile < this.listContent.length) {
            this.listContent[zeile] = "";
            ++zeile;
        }
    }

    public void showInventoryWaffen(ArrayList<Waffe> waffen) {
        this.clearTextArea();
        this.state = 1;
        this.writeText(String.valueOf(MainWindow.screenTexts.get("miInventoryWeapons")) + " :##");
        int i = 0;
        while (i < waffen.size()) {
            this.writeText(i + 1 + "." + waffen.get((int)i).name);
            ++i;
        }
        String[] chrName = new String[]{MainWindow.characters[MainWindow.selectedSurfaceCharacter].name};
        if (waffen.size() > 0) {
            this.writeText(MainWindow.screenTexts.get("tip_ready_weapon"), chrName);
        }
    }

    public void showInventoryRuestungen(ArrayList<Ruestung> ruestungen) {
        this.clearTextArea();
        this.state = 2;
        this.writeText(String.valueOf(MainWindow.screenTexts.get("miInventoryArmor")) + " :##");
        int i = 0;
        while (i < ruestungen.size()) {
            this.writeText(i + 1 + "." + ruestungen.get((int)i).name);
            ++i;
        }
        String[] chrName = new String[]{MainWindow.characters[MainWindow.selectedSurfaceCharacter].name};
        if (ruestungen.size() > 0) {
            this.writeText(MainWindow.screenTexts.get("tip_ready_armor"), chrName);
        }
    }

    public void showInventoryItems(ArrayList<Item> items) {
        this.clearTextArea();
        this.state = 3;
        this.writeText(String.valueOf(MainWindow.screenTexts.get("miInventoryItems")) + " :##");
        int i = 0;
        while (i < items.size()) {
            this.writeText(i + 1 + "." + items.get((int)i).name);
            ++i;
        }
    }

    public void writeTacMonsterMove(int direction, Monster mons) {
        String strDirection = MainWindow.screenTexts.get("north");
        if (direction == 1) {
            strDirection = MainWindow.screenTexts.get("east");
        }
        if (direction == 2) {
            strDirection = MainWindow.screenTexts.get("south");
        }
        if (direction == 3) {
            strDirection = MainWindow.screenTexts.get("west");
        }
        this.writeText(MainWindow.screenTexts.get("mons_go_dir"), new String[]{mons.type.name, strDirection});
        ++this.aktRow;
    }
}

