/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Character;
import classes.Dungeon;
import classes.Dungeonlevel;
import classes.Item;
import classes.Klasse;
import classes.Monster;
import classes.MonsterType;
import classes.NameMap;
import classes.Profession;
import classes.Ruestung;
import classes.Settlement;
import classes.Spell;
import classes.Spielstand;
import classes.SurfaceMap;
import classes.TacticScreen;
import classes.Waffe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import sound.SoundPlayer;
import tools.GameXMLDocument;
import ui.ChooserForLoad;
import ui.ChooserForSave;
import ui.GraphicsPanel;
import ui.HtmlPageViewer;
import ui.LoginSpielstandDialog;
import ui.NewGameWindow;
import ui.TextPanel;
import ui.ZahlungDialog;

public class MainWindow
extends Frame {
    private static final long serialVersionUID = 7509764308609412560L;
    public static boolean isInternetVersion = false;
    public static String internetBase = "http://www.junkgames.de/Phantasia1/RolePlay2D/";
    public static String savegameBase = "http://www.junkgames.de/Phantasia1/RolePlay2D/savegame/";
    private MainWindow me = this;
    public static boolean debug = false;
    public static SurfaceMap surfaceMap = null;
    public static NameMap nameMap = null;
    public static Settlement[] settlements = null;
    public static Dungeon[] dungeons = null;
    public static HashMap<Integer, MonsterType> monsterTypes = null;
    public static Klasse[] classes = null;
    public static Waffe[] waffen = null;
    public static Ruestung[] ruestungen = null;
    public static Profession[] professions = null;
    public static Character[] characters = null;
    public static TacticScreen[] tacticScreens = null;
    public static HashMap<String, String> screenTexts = null;
    public static Spell[] spells = null;
    public static HashMap<String, Object> gameParams = null;
    public static HashMap<String, String> commonCittexts = null;
    public static ArrayList<Waffe> inventoryWaffen = new ArrayList();
    public static ArrayList<Ruestung> inventoryRuestung = new ArrayList();
    public static ArrayList<Item> inventoryItems = new ArrayList();
    public static Spielstand spielstand = null;
    public static Monster[] surfaceMonsters = null;
    public static Monster[] tacticMonsters = null;
    public static String xmlFileName = "game.xml";
    public static GameXMLDocument xmlDoc = null;
    public static TextPanel pnlText;
    private static GraphicsPanel pnlGraphics;
    public static SoundPlayer sndPlayerWanderer;
    public static SoundPlayer sndPlayerTowns;
    public static SoundPlayer sndPlayerCombat;
    public static SoundPlayer sndPlayerDungeon;
    public static SoundPlayer sndPlayerDead;
    public static SoundPlayer sndPlayerCastle;
    public static SoundPlayer sndPlayerKloster;
    public static SoundPlayer sndPlayerShrine;
    public static SoundPlayer sndPlayerSndDefend;
    public static SoundPlayer sndPlayerSndMonsterAttack;
    public static SoundPlayer sndPlayerSndMonsterHitted;
    public static SoundPlayer sndPlayerSndMonsterNotHitted;
    public static int selectedSurfaceCharacter;
    public static boolean talk;
    public static int GAME_PARAM_POISON_EVERY_X_HIT;
    public static int GAME_PARAM_HPLOST_EVERY_X_POISONMOVE;
    public static int GAME_PARAM_HPHEAL_EVERY_X_MOVE;
    public static int GAME_PARAM_MPHEAL_EVERY_X_MOVE;
    public static int GAME_PARAM_EAT_FOOD_EVERY_X_MOVE;
    public static int GAME_PARAM_HPLOST_STARVING;
    public static int GAME_PARAM_TORCH_BURNS_FOR_X_MOVES;
    public static int GAME_PARAM_NEW_MONSTER_EVERY_X_ROUNDS;
    public static int GAME_PARAM_LIFETIME_MONSTER;
    public static int GAME_PARAM_PRIZE_HEAL;
    public static int GAME_PARAM_PRIZE_CURE;
    public static int GAME_PARAM_PRIZE_RESURRECT;
    public static int GAME_PARAM_PRIZE_FOOD;
    public static int GAME_PARAM_PRIZE_TORCH;
    public static int GAME_PARAM_PRIZE_KEY;

    static {
        pnlGraphics = null;
        sndPlayerWanderer = null;
        sndPlayerTowns = null;
        sndPlayerCombat = null;
        sndPlayerDungeon = null;
        sndPlayerDead = null;
        sndPlayerCastle = null;
        sndPlayerKloster = null;
        sndPlayerShrine = null;
        sndPlayerSndDefend = null;
        sndPlayerSndMonsterAttack = null;
        sndPlayerSndMonsterHitted = null;
        sndPlayerSndMonsterNotHitted = null;
        selectedSurfaceCharacter = 0;
        talk = false;
        GAME_PARAM_POISON_EVERY_X_HIT = 0;
        GAME_PARAM_HPLOST_EVERY_X_POISONMOVE = 0;
        GAME_PARAM_HPHEAL_EVERY_X_MOVE = 0;
        GAME_PARAM_MPHEAL_EVERY_X_MOVE = 0;
        GAME_PARAM_EAT_FOOD_EVERY_X_MOVE = 0;
        GAME_PARAM_HPLOST_STARVING = 0;
        GAME_PARAM_TORCH_BURNS_FOR_X_MOVES = 0;
        GAME_PARAM_NEW_MONSTER_EVERY_X_ROUNDS = 0;
        GAME_PARAM_LIFETIME_MONSTER = 0;
        GAME_PARAM_PRIZE_HEAL = 0;
        GAME_PARAM_PRIZE_CURE = 0;
        GAME_PARAM_PRIZE_RESURRECT = 0;
        GAME_PARAM_PRIZE_FOOD = 0;
        GAME_PARAM_PRIZE_TORCH = 0;
        GAME_PARAM_PRIZE_KEY = 0;
    }

    public static void main(String[] args) {
        MainWindow me = new MainWindow();
        me.setVisible(true);
    }

    public MainWindow() {
        this.setBounds(0, 0, 800, 600);
        this.setMinimumSize(new Dimension(640, 400));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent arg0) {
            }

            public void windowIconified(WindowEvent arg0) {
            }

            public void windowDeiconified(WindowEvent arg0) {
            }

            public void windowDeactivated(WindowEvent arg0) {
            }

            public void windowClosing(WindowEvent arg0) {
                System.exit(0);
            }

            public void windowClosed(WindowEvent arg0) {
            }

            public void windowActivated(WindowEvent arg0) {
            }
        });
        String fontName = null;
        GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = g.getAvailableFontFamilyNames();
        int i = 0;
        while (i < fonts.length) {
            if (fonts[i].equals("Lucida Console")) {
                fontName = "Lucida Console";
            }
            ++i;
        }
        if (fontName == null) {
            i = 0;
            while (i < fonts.length) {
                if (fonts[i].equals("Monospaced")) {
                    fontName = "Monospaced";
                }
                ++i;
            }
        }
        if (fontName == null) {
            fontName = "Courier";
        }
        UIManager.put("OptionPane.messageFont", new Font(fontName, 1, 15));
        if (isInternetVersion) {
            URL xmlFileUrl = null;
            try {
                xmlFileUrl = new URL(String.valueOf(internetBase) + "game.xml");
                xmlDoc = new GameXMLDocument(xmlFileUrl);
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
            }
        } else {
            xmlDoc = new GameXMLDocument(xmlFileName);
        }
        surfaceMap = xmlDoc.getSurfaceMap();
        nameMap = xmlDoc.getNameMap();
        settlements = xmlDoc.getSettlements();
        dungeons = xmlDoc.getDungeons();
        monsterTypes = xmlDoc.getMonsterTypes();
        classes = xmlDoc.getKlassen();
        waffen = xmlDoc.getWaffen();
        ruestungen = xmlDoc.getRuestungen();
        professions = xmlDoc.getProfession();
        tacticScreens = xmlDoc.getTacticScreens(null);
        commonCittexts = xmlDoc.getCommonCittexts();
        screenTexts = xmlDoc.getScreentext();
        spells = xmlDoc.getSpells();
        gameParams = xmlDoc.getGameParams();
        GAME_PARAM_POISON_EVERY_X_HIT = (Integer)gameParams.get("poison_every_x_hit");
        GAME_PARAM_HPHEAL_EVERY_X_MOVE = (Integer)gameParams.get("hpheal_every_x_move");
        GAME_PARAM_MPHEAL_EVERY_X_MOVE = (Integer)gameParams.get("mpheal_every_x_move");
        GAME_PARAM_HPLOST_EVERY_X_POISONMOVE = (Integer)gameParams.get("hplost_every_x_poisonmove");
        GAME_PARAM_EAT_FOOD_EVERY_X_MOVE = (Integer)gameParams.get("eat_food_every_x_move");
        GAME_PARAM_HPLOST_STARVING = (Integer)gameParams.get("hplost_starving");
        GAME_PARAM_TORCH_BURNS_FOR_X_MOVES = (Integer)gameParams.get("torch_burns_for_x_moves");
        GAME_PARAM_NEW_MONSTER_EVERY_X_ROUNDS = (Integer)gameParams.get("new_monster_every_x_rounds");
        GAME_PARAM_LIFETIME_MONSTER = (Integer)gameParams.get("lifetime_monster");
        GAME_PARAM_PRIZE_HEAL = (Integer)gameParams.get("prize_heal");
        GAME_PARAM_PRIZE_CURE = (Integer)gameParams.get("prize_cure");
        GAME_PARAM_PRIZE_RESURRECT = (Integer)gameParams.get("prize_resurrect");
        GAME_PARAM_PRIZE_FOOD = (Integer)gameParams.get("prize_food");
        GAME_PARAM_PRIZE_TORCH = (Integer)gameParams.get("prize_torch");
        GAME_PARAM_PRIZE_KEY = (Integer)gameParams.get("prize_key");
        spielstand = xmlDoc.getSpielstand();
        characters = MainWindow.spielstand.characters;
        int xpos = MainWindow.spielstand.posx;
        int ypos = MainWindow.spielstand.posy;
        surfaceMonsters = new Monster[20];
        tacticMonsters = new Monster[12];
        this.setLayout(new BorderLayout());
        try {
            if (isInternetVersion) {
                sndPlayerWanderer = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/surface.mid"), true);
                sndPlayerTowns = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/towns.mid"), true);
                sndPlayerCombat = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/kampf.mid"), true);
                sndPlayerDungeon = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/dungeon.mid"), true);
                sndPlayerDead = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/dead.mid"), true);
                sndPlayerCastle = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/castle.mid"), true);
                sndPlayerKloster = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/kloster.mid"), true);
                sndPlayerShrine = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/shrine.mid"), true);
                sndPlayerSndDefend = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/snd_defend.wav"), false);
                sndPlayerSndMonsterAttack = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/snd_monster_attack.wav"), false);
                sndPlayerSndMonsterNotHitted = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/snd_monster_not_hitted.wav"), false);
                sndPlayerSndMonsterHitted = new SoundPlayer(new URL(String.valueOf(internetBase) + "/sound/snd_monster_hitted.wav"), false);
            } else {
                sndPlayerWanderer = new SoundPlayer(this.getClass().getResource("/sound/surface.mid"), true);
                sndPlayerTowns = new SoundPlayer(this.getClass().getResource("/sound/towns.mid"), true);
                sndPlayerCombat = new SoundPlayer(this.getClass().getResource("/sound/kampf.mid"), true);
                sndPlayerDungeon = new SoundPlayer(this.getClass().getResource("/sound/dungeon.mid"), true);
                sndPlayerDead = new SoundPlayer(this.getClass().getResource("/sound/dead.mid"), true);
                sndPlayerCastle = new SoundPlayer(this.getClass().getResource("/sound/castle.mid"), true);
                sndPlayerKloster = new SoundPlayer(this.getClass().getResource("/sound/kloster.mid"), true);
                sndPlayerShrine = new SoundPlayer(this.getClass().getResource("/sound/shrine.mid"), true);
                sndPlayerSndDefend = new SoundPlayer(this.getClass().getResource("/sound/snd_defend.wav"), false);
                sndPlayerSndMonsterAttack = new SoundPlayer(this.getClass().getResource("/sound/snd_monster_attack.wav"), false);
                sndPlayerSndMonsterNotHitted = new SoundPlayer(this.getClass().getResource("/sound/snd_monster_not_hitted.wav"), false);
                sndPlayerSndMonsterHitted = new SoundPlayer(this.getClass().getResource("/sound/snd_monster_hitted.wav"), false);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (UnsupportedAudioFileException e1) {
            e1.printStackTrace();
        }
        catch (LineUnavailableException e1) {
            e1.printStackTrace();
        }
        catch (MidiUnavailableException e1) {
            e1.printStackTrace();
        }
        catch (InvalidMidiDataException e1) {
            e1.printStackTrace();
        }
        pnlGraphics = new GraphicsPanel(xpos, ypos);
        pnlGraphics.setBackground(Color.BLACK);
        this.add("Center", pnlGraphics);
        Panel pnlMenu = new Panel();
        FlowLayout pnlMenuLayout = new FlowLayout();
        pnlMenuLayout.setAlignment(0);
        pnlMenuLayout.setVgap(0);
        pnlMenuLayout.setHgap(0);
        pnlMenu.setLayout(pnlMenuLayout);
        JMenuBar menuBar = new JMenuBar();
        JMenu mGame = new JMenu(screenTexts.get("mGame"));
        JMenuItem miLoad = new JMenuItem(screenTexts.get("miLoad"));
        miLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.loadGame();
            }
        });
        JMenuItem miSave = new JMenuItem(screenTexts.get("miSave"));
        miSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveGame();
            }
        });
        JMenuItem miNew = new JMenuItem(screenTexts.get("miNew"));
        miNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.newGame();
            }
        });
        JMenuItem miSpielanleitung = new JMenuItem(screenTexts.get("miSpielanleitung"));
        miSpielanleitung.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.showHtmlPage(screenTexts.get("miSpielanleitung"), "/spielanleitung.htm");
            }
        });
        JMenuItem miHistory = new JMenuItem(screenTexts.get("miHistory"));
        miHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.showHtmlPage(screenTexts.get("miHistory"), "/history.htm");
            }
        });
        JMenuItem miProphety = new JMenuItem(screenTexts.get("miProphety"));
        miProphety.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.showHtmlPage(screenTexts.get("miProphety"), "/beschwoerung.html", 50, 0, 300, 740);
            }
        });
        mGame.add(miLoad);
        mGame.add(miSave);
        mGame.add(miNew);
        mGame.add(miSpielanleitung);
        mGame.add(miHistory);
        mGame.add(miProphety);
        mGame.setBackground(Color.WHITE);
        menuBar.add(mGame);
        JMenu mAnsicht = new JMenu(screenTexts.get("mView"));
        JMenuItem miZoomIn = new JMenuItem(screenTexts.get("miZoomIn"));
        miZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (pnlGraphics.zoom > 3) {
                    pnlGraphics.zoom -= 2;
                }
                pnlGraphics.resizeImages();
                pnlGraphics.paintComponent(pnlGraphics.getGraphics());
            }
        });
        JMenuItem miZoomOut = new JMenuItem(screenTexts.get("miZoomOut"));
        miZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (pnlGraphics.zoom <= MainWindow.surfaceMap.height && pnlGraphics.zoom <= MainWindow.surfaceMap.width) {
                    pnlGraphics.zoom += 2;
                }
                pnlGraphics.resizeImages();
                pnlGraphics.paintComponent(pnlGraphics.getGraphics());
            }
        });
        JMenu mFontSize = new JMenu(screenTexts.get("mFontsize"));
        JMenuItem miFontSize08 = new JMenuItem(screenTexts.get("miFontsize08"));
        miFontSize08.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setFontSize(8);
            }
        });
        mFontSize.add(miFontSize08);
        JMenuItem miFontSize10 = new JMenuItem(screenTexts.get("miFontsize10"));
        miFontSize10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setFontSize(10);
            }
        });
        mFontSize.add(miFontSize10);
        JMenuItem miFontSize12 = new JMenuItem(screenTexts.get("miFontsize12"));
        miFontSize12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setFontSize(12);
            }
        });
        mFontSize.add(miFontSize12);
        JMenuItem miFontSize14 = new JMenuItem(screenTexts.get("miFontsize14"));
        miFontSize14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setFontSize(14);
            }
        });
        mFontSize.add(miFontSize14);
        JMenuItem miFontSize16 = new JMenuItem(screenTexts.get("miFontsize16"));
        miFontSize16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setFontSize(16);
            }
        });
        mFontSize.add(miFontSize16);
        JMenuItem miFontSize20 = new JMenuItem(screenTexts.get("miFontsize20"));
        miFontSize20.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setFontSize(20);
            }
        });
        mFontSize.add(miFontSize20);
        JMenuItem miFontSize24 = new JMenuItem(screenTexts.get("miFontsize24"));
        miFontSize24.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.setFontSize(24);
            }
        });
        mFontSize.add(miFontSize24);
        mAnsicht.add(miZoomIn);
        mAnsicht.add(miZoomOut);
        mAnsicht.add(mFontSize);
        mAnsicht.setBackground(Color.WHITE);
        menuBar.add(mAnsicht);
        JMenu mSpells = new JMenu(screenTexts.get("mSpells"));
        JMenuItem[] miSpells = new JMenuItem[spells.length];
        int i2 = 0;
        while (i2 < miSpells.length) {
            miSpells[i2] = new JMenuItem(String.valueOf(MainWindow.spells[i2].key) + ") " + MainWindow.spells[i2].name + " (" + MainWindow.spells[i2].mp + " mp)");
            miSpells[i2].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    char key = ((JMenuItem)e.getSource()).getText().charAt(0);
                    pnlGraphics.doSpellcast(key);
                }
            });
            mSpells.add(miSpells[i2]);
            ++i2;
        }
        mSpells.setBackground(Color.WHITE);
        menuBar.add(mSpells);
        JMenu mCharacters = new JMenu(screenTexts.get("mCharacters"));
        JMenuItem[] miCharacters = new JMenuItem[characters.length];
        int i3 = 0;
        while (i3 < miCharacters.length) {
            miCharacters[i3] = new JMenuItem(i3 + 1 + ") " + screenTexts.get("miCharacter") + " " + (i3 + 1));
            miCharacters[i3].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    char key = ((JMenuItem)e.getSource()).getText().charAt(0);
                    int tmpChr = key - 48 - 1;
                    if (MainWindow.characters[tmpChr].zustand != 'D') {
                        selectedSurfaceCharacter = tmpChr;
                        pnlText.updateCharDetail(selectedSurfaceCharacter);
                    }
                }
            });
            mCharacters.add(miCharacters[i3]);
            ++i3;
        }
        mCharacters.setBackground(Color.WHITE);
        menuBar.add(mCharacters);
        JMenu mSonstiges = new JMenu(screenTexts.get("mMisc"));
        JMenuItem miFackelAnz = new JMenuItem("[f2] " + screenTexts.get("miLightTorch"));
        miFackelAnz.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pnlGraphics.lightTorch();
            }
        });
        mSonstiges.add(miFackelAnz);
        JMenuItem miSuchen = new JMenuItem("[f3] " + screenTexts.get("miSearch"));
        miSuchen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pnlGraphics.searchItem();
            }
        });
        mSonstiges.add(miSuchen);
        JMenuItem miInventoryWeapons = new JMenuItem("[f5] " + screenTexts.get("miInventoryWeapons"));
        miInventoryWeapons.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pnlText.showInventoryWaffen(inventoryWaffen);
            }
        });
        mSonstiges.add(miInventoryWeapons);
        JMenuItem miInventoryArmor = new JMenuItem("[f6] " + screenTexts.get("miInventoryArmor"));
        miInventoryArmor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pnlText.showInventoryRuestungen(inventoryRuestung);
            }
        });
        mSonstiges.add(miInventoryArmor);
        JMenuItem miInventoryItems = new JMenuItem("[f7] " + screenTexts.get("miInventoryItems"));
        miInventoryItems.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pnlText.showInventoryItems(inventoryItems);
            }
        });
        mSonstiges.add(miInventoryItems);
        mSonstiges.setBackground(Color.WHITE);
        menuBar.add(mSonstiges);
        JMenuItem miDungeonMap = new JMenuItem("[f8] " + screenTexts.get("miDungeonMap"));
        miDungeonMap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.showDungeonMap();
            }
        });
        mSonstiges.add(miDungeonMap);
        mSonstiges.setBackground(Color.WHITE);
        menuBar.add(mSonstiges);
        menuBar.setBackground(Color.WHITE);
        pnlMenu.add(menuBar);
        pnlMenu.setBackground(Color.WHITE);
        this.add("North", pnlMenu);
        pnlText = new TextPanel();
        pnlText.updateCharacters();
        pnlText.updateGoods(MainWindow.pnlGraphics.gold, MainWindow.pnlGraphics.food, MainWindow.pnlGraphics.keys, MainWindow.pnlGraphics.torches);
        this.add("East", pnlText);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!pnlGraphics.aktSoundPlayer.sequencer.isRunning()) {
                    pnlGraphics.startSoundPlayer(pnlGraphics.aktSoundPlayer);
                }
                if (talk) {
                    pnlGraphics.doKeyPressTalk(e);
                } else if (pnlGraphics.renderMode != 2) {
                    pnlGraphics.doKeyMoveNormal(e);
                } else {
                    pnlGraphics.doKeyMoveTactic(e);
                }
            }
        });
        pnlText.updateCharDetail(0);
        MainWindow.startNewGame(xmlDoc);
        pnlText.setFontSize(MainWindow.xmlDoc.getSpielstand().textSize);
        pnlText.clearTextArea();
        pnlText.writeText(screenTexts.get("game_start"));
        this.setFocusable(true);
        this.requestFocus();
    }

    public void setFontSize(int textsize) {
        pnlText.setFontSize(textsize);
        this.me.paintAll(this.me.getGraphics());
        pnlGraphics.resizeImages();
        pnlGraphics.paintComponent(pnlGraphics.getGraphics());
    }

    public static void startNewGame(GameXMLDocument spielstandSource) {
        if (spielstandSource != null) {
            Spielstand spielstand = spielstandSource.getSpielstand();
            MainWindow.pnlGraphics.xMapPosition = spielstand.posx;
            MainWindow.pnlGraphics.yMapPosition = spielstand.posy;
            MainWindow.pnlGraphics.xShipPosition = spielstand.posshipx;
            MainWindow.pnlGraphics.yShipPosition = spielstand.posshipy;
            MainWindow.pnlGraphics.gold = spielstand.gold;
            MainWindow.pnlGraphics.food = spielstand.food;
            MainWindow.pnlGraphics.keys = spielstand.keys;
            MainWindow.pnlGraphics.torches = spielstand.torches;
            MainWindow.pnlGraphics.onBoard = spielstand.onBoard == 1;
            MainWindow.pnlGraphics.aktSettlement = spielstand.aktSettlement;
            MainWindow.pnlGraphics.xSettPosition = spielstand.xSettPosition;
            MainWindow.pnlGraphics.ySettPosition = spielstand.ySettPosition;
            MainWindow.pnlGraphics.aktDungeon = spielstand.aktDungeon;
            MainWindow.pnlGraphics.xDungPosition = spielstand.xDungPosition;
            MainWindow.pnlGraphics.yDungPosition = spielstand.yDungPosition;
            MainWindow.pnlGraphics.aktDungLevel = spielstand.aktDungLevel;
            MainWindow.pnlGraphics.dungViewDirection = spielstand.dungViewDirection;
            MainWindow.pnlGraphics.light = spielstand.light;
            MainWindow.pnlGraphics.renderMode = spielstand.renderMode;
            MainWindow.pnlGraphics.oldRenderMode = spielstand.oldRenderMode;
            inventoryWaffen = spielstand.invWaffen;
            inventoryRuestung = spielstand.invRuestung;
            inventoryItems = spielstand.invItems;
            int i = 0;
            while (i < characters.length) {
                MainWindow.characters[i] = spielstand.characters[i];
                ++i;
            }
            if (MainWindow.pnlGraphics.renderMode == 3) {
                MainWindow.deleteAllTreasureDoorsAndMonstersInDungeon(MainWindow.pnlGraphics.aktDungLevel - 1);
                MainWindow.setKeyCountMinToAnzDoors();
            }
        } else {
            MainWindow.pnlGraphics.xMapPosition = 4;
            MainWindow.pnlGraphics.yMapPosition = 10;
            MainWindow.pnlGraphics.xShipPosition = 1;
            MainWindow.pnlGraphics.yShipPosition = 4;
            MainWindow.pnlGraphics.gold = 100;
            MainWindow.pnlGraphics.food = 100;
            MainWindow.pnlGraphics.keys = 20;
            MainWindow.pnlGraphics.torches = 25;
            inventoryWaffen = new ArrayList();
            inventoryRuestung = new ArrayList();
            inventoryItems = new ArrayList();
        }
        surfaceMonsters = new Monster[10];
        tacticMonsters = new Monster[12];
        switch (MainWindow.pnlGraphics.renderMode) {
            case 0: {
                pnlGraphics.startSoundPlayer(sndPlayerWanderer);
                break;
            }
            case 3: {
                pnlGraphics.startSoundPlayer(sndPlayerDungeon);
                break;
            }
            case 1: {
                if (MainWindow.surfaceMap.map[MainWindow.pnlGraphics.xMapPosition][MainWindow.pnlGraphics.yMapPosition] == 's') {
                    pnlGraphics.startSoundPlayer(sndPlayerTowns);
                }
                if (MainWindow.surfaceMap.map[MainWindow.pnlGraphics.xMapPosition][MainWindow.pnlGraphics.yMapPosition] == 'b') {
                    pnlGraphics.startSoundPlayer(sndPlayerCastle);
                }
                if (MainWindow.surfaceMap.map[MainWindow.pnlGraphics.xMapPosition][MainWindow.pnlGraphics.yMapPosition] == 'k') {
                    pnlGraphics.startSoundPlayer(sndPlayerKloster);
                }
                if (MainWindow.surfaceMap.map[MainWindow.pnlGraphics.xMapPosition][MainWindow.pnlGraphics.yMapPosition] != 'S') break;
                pnlGraphics.startSoundPlayer(sndPlayerShrine);
                break;
            }
            default: {
                pnlGraphics.startSoundPlayer(sndPlayerWanderer);
            }
        }
        pnlText.updateCharacters();
        pnlText.updateGoods(MainWindow.pnlGraphics.gold, MainWindow.pnlGraphics.food, MainWindow.pnlGraphics.keys, MainWindow.pnlGraphics.torches);
    }

    private static void deleteAllTreasureDoorsAndMonstersInDungeon(int bisLevel) {
        int i = 0;
        while (i <= bisLevel) {
            Dungeonlevel tempDungLevel = MainWindow.dungeons[MainWindow.pnlGraphics.aktDungeon].levels[i];
            int x = 0;
            while (x < tempDungLevel.mapWidth) {
                int y = 0;
                while (y < tempDungLevel.mapHeight) {
                    char tile = tempDungLevel.map[x][y];
                    boolean kill = false;
                    kill = tile != '*' && tile != 'u' && tile != 'd' && tile != 'h' && tile != 'c' && tile != 'p' && tile != 'm' && tile != 'a';
                    if (kill) {
                        MainWindow.dungeons[MainWindow.pnlGraphics.aktDungeon].levels[i].map[x][y] = 46;
                    }
                    ++y;
                }
                ++x;
            }
            ++i;
        }
    }

    private static void setKeyCountMinToAnzDoors() {
        Dungeonlevel tempDungLevel = MainWindow.dungeons[MainWindow.pnlGraphics.aktDungeon].levels[MainWindow.pnlGraphics.aktDungLevel];
        int doorCount = 0;
        int x = 0;
        while (x < tempDungLevel.mapWidth) {
            int y = 0;
            while (y < tempDungLevel.mapHeight) {
                char tile = tempDungLevel.map[x][y];
                if (tile == '1' || tile == '2' || tile == '3' || tile == '4') {
                    ++doorCount;
                }
                ++y;
            }
            ++x;
        }
        if (doorCount > MainWindow.pnlGraphics.keys) {
            MainWindow.pnlGraphics.keys = doorCount;
        }
    }

    private void showHtmlPage(String title, String link) {
        HtmlPageViewer htmlViewer = new HtmlPageViewer(title, link);
        htmlViewer.setVisible(true);
    }

    private void showHtmlPage(String title, String link, int x, int y, int width, int height) {
        HtmlPageViewer htmlViewer = new HtmlPageViewer(title, link, x, y, width, height);
        htmlViewer.setVisible(true);
    }

    public void showZahlungDialog(String username, String password, String filename) {
        String strLink = String.valueOf(internetBase) + "paybest1.php?username=" + username + "&password=" + password + "&filename=" + filename;
        ZahlungDialog dlgZahlung = new ZahlungDialog(strLink);
        dlgZahlung.setVisible(true);
    }

    private void newGame() {
        NewGameWindow dlg = new NewGameWindow();
        dlg.setVisible(true);
        if (dlg.isWasOk) {
            MainWindow.pnlGraphics.renderMode = 0;
            MainWindow.pnlGraphics.onBoard = false;
            MainWindow.startNewGame(null);
            this.setFontSize(12);
        }
    }

    private void loadGame() {
        if (isInternetVersion) {
            try {
                LoginSpielstandDialog dlgLoginSpielstand = new LoginSpielstandDialog(true);
                dlgLoginSpielstand.setVisible(true);
                String username = dlgLoginSpielstand.username;
                String password = dlgLoginSpielstand.password;
                dlgLoginSpielstand.dispose();
                if (username != null && password != null) {
                    URL listUrl = new URL(String.valueOf(internetBase) + "getSpielstand01List.pl?username=" + username + "&password=" + password);
                    InputStream is = listUrl.openStream();
                    if (is.available() > 0) {
                        String dbResult = new Scanner(is).useDelimiter("\\Z").next();
                        String[] arDbResult = dbResult.split("\\n");
                        ChooserForLoad chooser = new ChooserForLoad(arDbResult, username, password);
                        chooser.setVisible(true);
                        if (chooser.strChosen != null) {
                            if (chooser.bezahlt) {
                                String filename = String.valueOf(username) + "_" + password + "_" + chooser.strChosen;
                                URL loadUrl = new URL(String.valueOf(savegameBase) + filename);
                                GameXMLDocument locXmlDoc = new GameXMLDocument(loadUrl);
                                MainWindow.startNewGame(locXmlDoc);
                                this.setFontSize(locXmlDoc.getSpielstand().textSize);
                            } else {
                                this.showZahlungDialog(username, password, chooser.strChosen);
                            }
                        }
                        chooser.dispose();
                    } else {
                        JOptionPane.showMessageDialog(this, screenTexts.get("dlgLoadNoUserPw").replace("#", "\n"));
                    }
                    is.close();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            File dirFile = new File("./savegame");
            JFileChooser chooser = new JFileChooser(dirFile);
            int returnVal = chooser.showOpenDialog(this);
            String chosenFile = null;
            if (returnVal == 0) {
                chosenFile = chooser.getSelectedFile().getAbsolutePath();
            }
            if (chosenFile == null) {
                return;
            }
            GameXMLDocument locXmlDoc = new GameXMLDocument(chosenFile);
            MainWindow.startNewGame(locXmlDoc);
            this.setFontSize(locXmlDoc.getSpielstand().textSize);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveGame() {
        if (MainWindow.pnlGraphics.renderMode != 2) {
            if (isInternetVersion) {
                try {
                    LoginSpielstandDialog dlgLoginSpielstand = new LoginSpielstandDialog(false);
                    dlgLoginSpielstand.setVisible(true);
                    String username = dlgLoginSpielstand.username;
                    String password = dlgLoginSpielstand.password;
                    dlgLoginSpielstand.dispose();
                    if (username == null || password == null) return;
                    URL listUrl = new URL(String.valueOf(internetBase) + "getSpielstand01List.pl?username=" + username + "&password=" + password);
                    InputStream isList = listUrl.openStream();
                    if (isList.available() > 0) {
                        String dbResult = new Scanner(isList).useDelimiter("\\Z").next();
                        String[] arDbResult = dbResult.split("\\n");
                        ChooserForSave chooser = new ChooserForSave(arDbResult, username, password);
                        chooser.setVisible(true);
                        if (chooser.strChosen != null) {
                            if (chooser.bezahlt) {
                                String xmlContent = this.buildXMLSavegame();
                                xmlContent = URLEncoder.encode(xmlContent, "UTF-8");
                                URL updateUrl = new URL(String.valueOf(internetBase) + "updateSpielstand.pl?username=" + username + "&password=" + password + "&filename=" + chooser.strChosen.trim().split(" ")[0] + "&contents=" + xmlContent);
                                InputStream isUpdate = updateUrl.openStream();
                                if (isUpdate.available() > 0) {
                                    String updateResult = new Scanner(isUpdate).useDelimiter("\\Z").next();
                                    String reloadWarn = "\n\n" + screenTexts.get("dlgReloadWarn").replace("#", "\n");
                                    JOptionPane.showMessageDialog(this, String.valueOf(updateResult) + reloadWarn);
                                }
                                isUpdate.close();
                            } else {
                                this.showZahlungDialog(username, password, chooser.strChosen);
                            }
                        } else if (chooser.strNewFilename != null) {
                            this.saveNewSpielstandOnServer(username, password, chooser.strNewFilename.trim());
                        }
                        chooser.dispose();
                    } else {
                        ChooserForSave chooser = new ChooserForSave(null, username, password);
                        chooser.setVisible(true);
                        if (chooser.strNewFilename != null) {
                            this.saveNewSpielstandOnServer(username, password, chooser.strNewFilename.trim());
                        }
                        chooser.dispose();
                    }
                    isList.close();
                    return;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            File dirFile = new File("./savegame");
            JFileChooser chooser = new JFileChooser(dirFile);
            int returnVal = chooser.showSaveDialog(this);
            String chosenFile = null;
            if (returnVal == 0) {
                chosenFile = chooser.getSelectedFile().getAbsolutePath();
            }
            if (chosenFile == null) {
                return;
            }
            String xmlContent = this.buildXMLSavegame();
            FileWriter fw = null;
            try {
                try {
                    fw = new FileWriter(chosenFile);
                    fw.write(xmlContent);
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (fw == null) return;
                        fw.close();
                        return;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return;
            }
            finally {
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        JOptionPane.showMessageDialog(this, screenTexts.get("dlgNoSave"));
    }

    private void saveNewSpielstandOnServer(String username, String password, String filename) throws IOException {
        String xmlContent = this.buildXMLSavegame();
        xmlContent = URLEncoder.encode(xmlContent, "UTF-8");
        URL insertNewUserUrl = new URL(String.valueOf(internetBase) + "insertSpielstand.pl?username=" + username + "&password=" + password + "&filename=" + filename + "&contents=" + xmlContent);
        InputStream isInsertNewUser = insertNewUserUrl.openStream();
        if (isInsertNewUser.available() > 0) {
            String insertResult = new Scanner(isInsertNewUser).useDelimiter("\\Z").next();
            if (insertResult.equalsIgnoreCase("Game Saved")) {
                this.showZahlungDialog(username, password, filename);
            } else {
                JOptionPane.showMessageDialog(this, "Die Datei konnte nicht gespeichert werden.");
            }
        }
        isInsertNewUser.close();
    }

    private String buildXMLSavegame() {
        String strCsvWaffen = "";
        int i = 0;
        while (i < inventoryWaffen.size()) {
            int i2 = 0;
            while (i2 < waffen.length) {
                if (inventoryWaffen.get(i).equals(waffen[i2])) {
                    strCsvWaffen = String.valueOf(strCsvWaffen) + i2 + ",";
                }
                ++i2;
            }
            ++i;
        }
        if (strCsvWaffen.length() > 1) {
            strCsvWaffen = strCsvWaffen.substring(0, strCsvWaffen.length() - 1);
        }
        String strCsvRuestung = "";
        int i2 = 0;
        while (i2 < inventoryRuestung.size()) {
            int i22 = 0;
            while (i22 < ruestungen.length) {
                if (inventoryRuestung.get(i2).equals(ruestungen[i22])) {
                    strCsvRuestung = String.valueOf(strCsvRuestung) + i22 + ",";
                }
                ++i22;
            }
            ++i2;
        }
        if (strCsvRuestung.length() > 1) {
            strCsvRuestung = strCsvRuestung.substring(0, strCsvRuestung.length() - 1);
        }
        String strElItems = "";
        int i3 = 0;
        while (i3 < inventoryItems.size()) {
            Item item = inventoryItems.get(i3);
            strElItems = String.valueOf(strElItems) + "<item name=\"" + item.name + "\" x=\"" + item.x + "\" y=\"" + item.y + "\" effect=\"" + item.effect + "\" param=\"" + item.param + "\"/>";
            ++i3;
        }
        String xmlContent = "<?xml version=\"1.0\" encoding = \"UTF-8\"?><game><spielstand posx=\"" + MainWindow.pnlGraphics.xMapPosition + "\" " + "posy=\"" + MainWindow.pnlGraphics.yMapPosition + "\" " + "posshipx=\"" + MainWindow.pnlGraphics.xShipPosition + "\" " + "posshipy=\"" + MainWindow.pnlGraphics.yShipPosition + "\" " + "gold=\"" + MainWindow.pnlGraphics.gold + "\" " + "food = \"" + MainWindow.pnlGraphics.food + "\" " + "keys=\"" + MainWindow.pnlGraphics.keys + "\" " + "torches=\"" + MainWindow.pnlGraphics.torches + "\" " + "textsize=\"" + MainWindow.pnlText.font.getSize() + "\" " + "onBoard=\"" + (MainWindow.pnlGraphics.onBoard ? 1 : 0) + "\" " + "aktSettlement=\"" + MainWindow.pnlGraphics.aktSettlement + "\" " + "xSettPosition=\"" + MainWindow.pnlGraphics.xSettPosition + "\" " + "ySettPosition=\"" + MainWindow.pnlGraphics.ySettPosition + "\" " + "aktDungeon=\"" + MainWindow.pnlGraphics.aktDungeon + "\" " + "xDungPosition=\"" + MainWindow.pnlGraphics.xDungPosition + "\" " + "yDungPosition=\"" + MainWindow.pnlGraphics.yDungPosition + "\" " + "aktDungLevel=\"" + MainWindow.pnlGraphics.aktDungLevel + "\" " + "dungViewDirection=\"" + MainWindow.pnlGraphics.dungViewDirection + "\" " + "light=\"" + MainWindow.pnlGraphics.light + "\" " + "renderMode=\"" + MainWindow.pnlGraphics.renderMode + "\" " + "oldRenderMode=\"" + MainWindow.pnlGraphics.oldRenderMode + "\" " + ">" + "<character name=\"" + MainWindow.characters[0].name + "\"\tkl=\"" + MainWindow.characters[0].klasse + "\"\tpr=\"" + MainWindow.characters[0].profession + "\"\tlv=\"" + MainWindow.characters[0].level + "\"\takthp=\"" + MainWindow.characters[0].aktHp + "\"\taktmg=\"" + MainWindow.characters[0].aktMg + "\"\thp=\"" + MainWindow.characters[0].hp + "\"\tst=\"" + MainWindow.characters[0].st + "\"\tdx=\"" + MainWindow.characters[0].dx + "\"\tmg=\"" + MainWindow.characters[0].mg + "\"\trs=\"" + MainWindow.characters[0].ruestung + "\"\twf=\"" + MainWindow.characters[0].waffe + "\" exp=\"" + MainWindow.characters[0].exp + "\" zustand=\"" + MainWindow.characters[0].zustand + "\"/>" + "<character name=\"" + MainWindow.characters[1].name + "\"\tkl=\"" + MainWindow.characters[1].klasse + "\"\tpr=\"" + MainWindow.characters[1].profession + "\"\tlv=\"" + MainWindow.characters[1].level + "\"\takthp=\"" + MainWindow.characters[1].aktHp + "\"\taktmg=\"" + MainWindow.characters[1].aktMg + "\"\thp=\"" + MainWindow.characters[1].hp + "\"\tst=\"" + MainWindow.characters[1].st + "\"\tdx=\"" + MainWindow.characters[1].dx + "\"\tmg=\"" + MainWindow.characters[1].mg + "\"\trs=\"" + MainWindow.characters[1].ruestung + "\"\twf=\"" + MainWindow.characters[1].waffe + "\" exp=\"" + MainWindow.characters[1].exp + "\" zustand=\"" + MainWindow.characters[1].zustand + "\"/>" + "<character name=\"" + MainWindow.characters[2].name + "\"\tkl=\"" + MainWindow.characters[2].klasse + "\"\tpr=\"" + MainWindow.characters[2].profession + "\"\tlv=\"" + MainWindow.characters[2].level + "\"\takthp=\"" + MainWindow.characters[2].aktHp + "\"\taktmg=\"" + MainWindow.characters[2].aktMg + "\"\thp=\"" + MainWindow.characters[2].hp + "\"\tst=\"" + MainWindow.characters[2].st + "\"\tdx=\"" + MainWindow.characters[2].dx + "\"\tmg=\"" + MainWindow.characters[2].mg + "\"\trs=\"" + MainWindow.characters[2].ruestung + "\"\twf=\"" + MainWindow.characters[2].waffe + "\" exp=\"" + MainWindow.characters[2].exp + "\" zustand=\"" + MainWindow.characters[2].zustand + "\"/>" + "<character name=\"" + MainWindow.characters[3].name + "\"\tkl=\"" + MainWindow.characters[3].klasse + "\"\tpr=\"" + MainWindow.characters[3].profession + "\"\tlv=\"" + MainWindow.characters[3].level + "\"\takthp=\"" + MainWindow.characters[3].aktHp + "\"\taktmg=\"" + MainWindow.characters[3].aktMg + "\"\thp=\"" + MainWindow.characters[3].hp + "\"\tst=\"" + MainWindow.characters[3].st + "\"\tdx=\"" + MainWindow.characters[3].dx + "\"\tmg=\"" + MainWindow.characters[3].mg + "\"\trs=\"" + MainWindow.characters[3].ruestung + "\"\twf=\"" + MainWindow.characters[3].waffe + "\" exp=\"" + MainWindow.characters[3].exp + "\" zustand=\"" + MainWindow.characters[3].zustand + "\"/>" + "<inv_waffen>" + strCsvWaffen + "</inv_waffen>" + "<inv_ruest>" + strCsvRuestung + "</inv_ruest>" + "<inv_items>" + strElItems + "</inv_items>" + "</spielstand>" + "</game>";
        xmlContent = this.replaceUmlautsBack(xmlContent);
        return xmlContent;
    }

    public static void showDungeonMap() {
        boolean playerHasMap = false;
        int i = 0;
        while (i < inventoryItems.size()) {
            Item item = inventoryItems.get(i);
            if (item.effect.equalsIgnoreCase("map_dungeon") && item.param.equalsIgnoreCase(MainWindow.dungeons[MainWindow.pnlGraphics.aktDungeon].name)) {
                playerHasMap = true;
            }
            ++i;
        }
        if (MainWindow.pnlGraphics.renderMode == 3 && playerHasMap && MainWindow.pnlGraphics.light > 0) {
            char[][] map = MainWindow.dungeons[MainWindow.pnlGraphics.aktDungeon].levels[MainWindow.pnlGraphics.aktDungLevel].map;
            String strMap = "";
            int row = 0;
            while (row < map[0].length) {
                String strMapRow = "";
                int col = 0;
                while (col < map.length) {
                    String strChar = "  ";
                    switch (map[col][row]) {
                        case '*': {
                            strChar = "[]";
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': {
                            strChar = "||";
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': {
                            strChar = "GG";
                            break;
                        }
                        case 'a': {
                            strChar = "AL";
                            break;
                        }
                        case 'c': 
                        case 'h': 
                        case 'm': 
                        case 'p': {
                            strChar = "()";
                            break;
                        }
                        case 'u': {
                            strChar = "UP";
                            break;
                        }
                        case 'd': {
                            strChar = "DN";
                        }
                    }
                    if (row == MainWindow.pnlGraphics.yDungPosition && col == MainWindow.pnlGraphics.xDungPosition) {
                        strChar = "><";
                        switch (MainWindow.pnlGraphics.dungViewDirection) {
                            case 0: {
                                strChar = ">>";
                                break;
                            }
                            case 2: {
                                strChar = "<<";
                                break;
                            }
                            case 3: {
                                strChar = "^^";
                                break;
                            }
                            case 1: {
                                strChar = "vv";
                            }
                        }
                    }
                    strMapRow = String.valueOf(strMapRow) + strChar;
                    ++col;
                }
                strMap = String.valueOf(strMap) + strMapRow + "\n";
                ++row;
            }
            JOptionPane.showMessageDialog(null, strMap, String.valueOf(MainWindow.dungeons[MainWindow.pnlGraphics.aktDungeon].name) + " Level " + (MainWindow.pnlGraphics.aktDungLevel + 1), -1);
        } else if (MainWindow.pnlGraphics.renderMode == 3 && !playerHasMap) {
            JOptionPane.showMessageDialog(null, screenTexts.get("dlgNoMap").replace("#", "\n"));
        } else if (MainWindow.pnlGraphics.renderMode == 3 && MainWindow.pnlGraphics.light < 1) {
            JOptionPane.showMessageDialog(null, screenTexts.get("dlgDarkMap"));
        }
    }

    private String replaceUmlautsBack(String text) {
        text = text.replace("\u00e4", "{a}");
        text = text.replace("\u00f6", "{o}");
        text = text.replace("\u00fc", "{u}");
        text = text.replace("\u00c4", "{A}");
        text = text.replace("\u00d6", "{O}");
        text = text.replace("\u00dc", "{U}");
        text = text.replace("\u00df", "{s}");
        return text;
    }
}

