/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlPageViewer
extends JFrame
implements HyperlinkListener {
    private static final long serialVersionUID = -2560205337937498552L;
    private JEditorPane tp = null;

    public HtmlPageViewer(String title, String strHtmlLink, int x, int y, int width, int height) {
        this.buildWindow(title, strHtmlLink, x, y, width, height);
    }

    public HtmlPageViewer(String title, String strHtmlLink) {
        this.buildWindow(title, strHtmlLink, 100, 0, 700, 600);
    }

    private void buildWindow(String title, String strHtmlLink, int x, int y, int width, int height) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.addWindowListener(new WindowListener(){

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                HtmlPageViewer.this.setVisible(false);
                HtmlPageViewer.this.dispose();
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }
        });
        this.setTitle(title);
        this.tp = new JEditorPane();
        this.tp.setContentType("text/html");
        this.tp.addHyperlinkListener(this);
        this.tp.setEditorKit(new HTMLEditorKit());
        this.tp.setEditable(false);
        JScrollPane js = new JScrollPane();
        js.getViewport().add(this.tp);
        this.getContentPane().add(js);
        this.pack();
        this.setBounds(x, y, width, height);
        try {
            URL url = new URL(strHtmlLink);
            this.tp.setPage(url);
        }
        catch (MalformedURLException e) {
            try {
                URL url = this.getClass().getResource(strHtmlLink);
                this.tp.setPage(url);
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.tp.setPage(e.getURL());
            }
            catch (Exception e1) {
                System.out.println("Abbruch --> wrong URL: " + e.toString());
                e1.printStackTrace();
            }
        }
    }
}

