/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Character;
import classes.Citizen;
import classes.Dungeonlevel;
import classes.Item;
import classes.Monster;
import classes.MonsterType;
import classes.NameMapTile;
import classes.Profession;
import classes.Ruestung;
import classes.Spell;
import classes.TacticScreen;
import classes.Tile;
import classes.Waffe;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import sound.SoundPlayer;
import tools.ConsoleLogger;
import tools.HelpMethods;
import ui.MainWindow;

public class GraphicsPanel
extends JPanel {
    private static final long serialVersionUID = -4351230898055160467L;
    private static final ConsoleLogger log = new ConsoleLogger();
    private int scaleFacX = 1;
    private int scaleFacY = 1;
    private int aktHeight = this.getHeight();
    private int aktWidth = this.getWidth();
    public int zoom = 11;
    private Image[] imgOrg = null;
    private Image[] img = null;
    private Tile[] tiles = null;
    public static final int RENDER_MODE_WILDERNESS = 0;
    public static final int RENDER_MODE_SETTLEMENT = 1;
    public static final int RENDER_MODE_TACTICS = 2;
    public static final int RENDER_MODE_DUNGEON = 3;
    public int renderMode = 0;
    public int oldRenderMode = 0;
    public int gold = 0;
    public int food = 0;
    public int keys = 0;
    public int torches = 0;
    public int xMapPosition = 3;
    public int yMapPosition = 10;
    private int aktSurfaceEnemy = 0;
    public boolean onBoard = false;
    public int xShipPosition = 1;
    public int yShipPosition = 1;
    private int shipRenderDirection = 1;
    public int aktSettlement = 0;
    public int xSettPosition = 0;
    public int ySettPosition = 0;
    private String inputRow = "";
    private int aktCitizen = 0;
    public int aktDungeon = 0;
    public int xDungPosition = 1;
    public int yDungPosition = 1;
    public int aktDungLevel = -1;
    public int dungViewDirection = 0;
    public int light = 0;
    private int aktTacticScreen = 0;
    private int selectedCharacter = 0;
    private int xHit = 0;
    private int yHit = 0;
    private boolean renderHit = false;
    private int xEnemyHit = 0;
    private int yEnemyHit = 0;
    private boolean renderEnemyHit = false;
    public SoundPlayer aktSoundPlayer = null;

    public GraphicsPanel(int xpos, int ypos) {
        this.xMapPosition = xpos;
        this.yMapPosition = ypos;
        this.loadTiles();
        this.loadImages();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                GraphicsPanel.this.resizeImages();
            }
        });
        this.aktSoundPlayer = MainWindow.sndPlayerKloster;
        this.aktSoundPlayer.play();
    }

    private void initTalk() {
        this.inputRow = "|";
        ++MainWindow.pnlText.aktRow;
        MainWindow.pnlText.writeText(this.inputRow, MainWindow.pnlText.aktRow);
        --MainWindow.pnlText.aktRow;
        MainWindow.talk = true;
    }

    private void parseTalk() {
        boolean found = false;
        if (this.inputRow.length() > 1) {
            this.inputRow = this.inputRow.substring(0, this.inputRow.length() - 1);
            MainWindow.pnlText.writeText(this.inputRow, MainWindow.pnlText.aktRow);
            --MainWindow.pnlText.aktRow;
        } else {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("end_talk"));
            MainWindow.talk = false;
            return;
        }
        Citizen cit = MainWindow.settlements[this.aktSettlement].citizens.get(this.aktCitizen);
        ArrayList<String> key = cit.keys;
        int i = 0;
        while (i < key.size()) {
            String tempInputRow;
            String strCompare;
            if (this.inputRow.equalsIgnoreCase(MainWindow.screenTexts.get("name"))) {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("my_name_is")) + cit.name);
                found = true;
            }
            if ((strCompare = key.get(i)).length() <= this.inputRow.length() && (tempInputRow = this.inputRow.substring(0, strCompare.length())).equalsIgnoreCase(strCompare)) {
                found = true;
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(this.replaceShopTexts(cit.cittexts.get(i)));
                this.doTalkActions(cit.actions.get(i), cit.param.get(i));
            }
            ++i;
        }
        if (!found) {
            if (MainWindow.commonCittexts.get(this.inputRow.trim().toUpperCase()) != null) {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.commonCittexts.get(this.inputRow.trim().toUpperCase()));
            } else {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_understand"));
            }
        }
        this.initTalk();
    }

    private String replaceShopTexts(String text) {
        int i = 0;
        while (i < MainWindow.waffen.length) {
            String strWaffePreis = MainWindow.pnlText.formatListContent(MainWindow.waffen[i].name, String.valueOf(MainWindow.waffen[i].preis) + " G", MainWindow.pnlText.listContent[0].length() - 5);
            text = text.replace("[waffe|" + MainWindow.waffen[i].name + "]", strWaffePreis);
            ++i;
        }
        i = 0;
        while (i < MainWindow.ruestungen.length) {
            String strRuestPreis = MainWindow.pnlText.formatListContent(MainWindow.ruestungen[i].name, String.valueOf(MainWindow.ruestungen[i].preis) + " Gold", MainWindow.pnlText.listContent[0].length() - 5);
            text = text.replace("[ruestung|" + MainWindow.ruestungen[i].name + "]", strRuestPreis);
            ++i;
        }
        text = text.replace("[invWaffe]", this.getInventoryWaffe());
        text = text.replace("[prize_heal]", "" + MainWindow.GAME_PARAM_PRIZE_HEAL);
        text = text.replace("[prize_cure]", "" + MainWindow.GAME_PARAM_PRIZE_CURE);
        text = text.replace("[prize_resurrect]", "" + MainWindow.GAME_PARAM_PRIZE_RESURRECT);
        text = text.replace("[prize_food]", "" + MainWindow.GAME_PARAM_PRIZE_FOOD);
        text = text.replace("[prize_torch]", "" + MainWindow.GAME_PARAM_PRIZE_TORCH);
        text = text.replace("[prize_key]", "" + MainWindow.GAME_PARAM_PRIZE_KEY);
        return text;
    }

    private String getInventoryWaffe() {
        String result = "";
        int i = 0;
        while (i < MainWindow.inventoryWaffen.size()) {
            result = String.valueOf(result) + ("#~. " + MainWindow.inventoryWaffen.get((int)i).name).replace('~', (char)(97 + i)) + " " + MainWindow.inventoryWaffen.get((int)i).preis + " Gold";
            ++i;
        }
        return result;
    }

    private void doTalkActions(int action, String param) {
        int i;
        if (action == 1) {
            int toHealCharacter = Integer.parseInt(param) - 1;
            if (this.gold >= MainWindow.GAME_PARAM_PRIZE_HEAL) {
                if (MainWindow.characters[toHealCharacter].zustand != 'D') {
                    MainWindow.characters[toHealCharacter].aktHp = MainWindow.characters[toHealCharacter].hp;
                    MainWindow.characters[toHealCharacter].zustand = (char)71;
                    this.gold -= MainWindow.GAME_PARAM_PRIZE_HEAL;
                    MainWindow.pnlText.updateCharacters();
                    MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                } else {
                    MainWindow.pnlText.clearTextArea();
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_heal_dead"));
                }
            } else {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_enough_money"));
            }
        }
        if (action == 2) {
            Waffe waffe = null;
            i = 0;
            while (i < MainWindow.waffen.length) {
                if (param.equalsIgnoreCase(MainWindow.waffen[i].name)) {
                    waffe = MainWindow.waffen[i];
                }
                ++i;
            }
            if (waffe != null) {
                if (this.gold >= waffe.preis) {
                    MainWindow.inventoryWaffen.add(waffe);
                    this.gold -= waffe.preis;
                    MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                } else {
                    MainWindow.pnlText.clearTextArea();
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_enough_money"));
                }
            }
        }
        if (action == 3) {
            boolean sold = false;
            i = 0;
            while (i < MainWindow.inventoryWaffen.size()) {
                if (MainWindow.inventoryWaffen.get((int)i).name.equalsIgnoreCase(param) && !sold) {
                    sold = true;
                    this.gold += MainWindow.inventoryWaffen.get((int)i).preis;
                    MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                    MainWindow.inventoryWaffen.remove(i);
                    break;
                }
                ++i;
            }
            if (!sold) {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_such_weapon"));
            }
        }
        if (action == 4) {
            Ruestung ruestung = null;
            i = 0;
            while (i < MainWindow.ruestungen.length) {
                if (param.equalsIgnoreCase(MainWindow.ruestungen[i].name)) {
                    ruestung = MainWindow.ruestungen[i];
                }
                ++i;
            }
            if (ruestung != null) {
                if (this.gold >= ruestung.preis) {
                    MainWindow.inventoryRuestung.add(ruestung);
                    this.gold -= ruestung.preis;
                    MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                } else {
                    MainWindow.pnlText.clearTextArea();
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_enough_money"));
                }
            }
        }
        if (action == 5) {
            boolean sold = false;
            i = 0;
            while (i < MainWindow.inventoryRuestung.size()) {
                if (MainWindow.inventoryRuestung.get((int)i).name.equalsIgnoreCase(param) && !sold) {
                    sold = true;
                    this.gold += MainWindow.inventoryRuestung.get((int)i).preis;
                    MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                    MainWindow.inventoryRuestung.remove(i);
                    break;
                }
                ++i;
            }
            if (!sold) {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_such_armor"));
            }
        }
        if (action == 6) {
            if (this.gold >= MainWindow.GAME_PARAM_PRIZE_CURE) {
                if (this.cureAll()) {
                    this.gold -= MainWindow.GAME_PARAM_PRIZE_CURE;
                    MainWindow.pnlText.clearTextArea();
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("cured"));
                    MainWindow.pnlText.updateCharacters();
                    MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                } else {
                    MainWindow.pnlText.clearTextArea();
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_poison"));
                }
            } else {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_enough_money"));
            }
        }
        if (action == 7) {
            if (this.gold >= MainWindow.GAME_PARAM_PRIZE_RESURRECT) {
                if (this.resurrectAll()) {
                    this.gold -= MainWindow.GAME_PARAM_PRIZE_RESURRECT;
                    MainWindow.pnlText.clearTextArea();
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("resurrection"));
                    MainWindow.pnlText.updateCharacters();
                    MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                } else {
                    MainWindow.pnlText.clearTextArea();
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_dead"));
                }
            } else {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_enough_money"));
            }
        }
        if (action == 8) {
            if (this.gold >= MainWindow.GAME_PARAM_PRIZE_FOOD) {
                this.gold -= MainWindow.GAME_PARAM_PRIZE_FOOD;
                this.food += 10;
                MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
            } else {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_enough_money"));
            }
        }
        if (action == 9) {
            if (this.gold >= MainWindow.GAME_PARAM_PRIZE_TORCH) {
                this.gold -= MainWindow.GAME_PARAM_PRIZE_TORCH;
                this.torches += 5;
                MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
            } else {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_enough_money"));
            }
        }
        if (action == 10) {
            if (this.gold >= MainWindow.GAME_PARAM_PRIZE_KEY) {
                this.gold -= MainWindow.GAME_PARAM_PRIZE_KEY;
                this.keys += 3;
                MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
            } else {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("not_enough_money"));
            }
        }
    }

    public void doKeyPressTalk(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.parseTalk();
        } else if (e.getKeyCode() != 16) {
            if (e.getKeyCode() == 8 || e.getKeyCode() == 37) {
                if (this.inputRow.length() > 1) {
                    this.inputRow = String.valueOf(this.inputRow.substring(0, this.inputRow.length() - 2)) + "|";
                    MainWindow.pnlText.writeText(this.inputRow, MainWindow.pnlText.aktRow);
                    --MainWindow.pnlText.aktRow;
                }
            } else if (e.getKeyCode() != 39 && e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                this.inputRow = this.inputRow.substring(0, this.inputRow.length() - 1);
                this.inputRow = String.valueOf(this.inputRow) + e.getKeyChar() + "|";
                MainWindow.pnlText.writeText(this.inputRow, MainWindow.pnlText.aktRow);
                --MainWindow.pnlText.aktRow;
            }
        }
    }

    public void doKeyMoveNormal(KeyEvent e) {
        int xMapAlt = this.xMapPosition;
        int yMapAlt = this.yMapPosition;
        if (this.light > 0) {
            --this.light;
        }
        int xMov = 0;
        int yMov = 0;
        if (e.getKeyCode() == 49 && MainWindow.characters.length >= 1 && MainWindow.characters[0].zustand != 'D') {
            MainWindow.selectedSurfaceCharacter = 0;
            MainWindow.pnlText.updateCharDetail(MainWindow.selectedSurfaceCharacter);
        }
        if (e.getKeyCode() == 50 && MainWindow.characters.length >= 2 && MainWindow.characters[1].zustand != 'D') {
            MainWindow.selectedSurfaceCharacter = 1;
            MainWindow.pnlText.updateCharDetail(MainWindow.selectedSurfaceCharacter);
        }
        if (e.getKeyCode() == 51 && MainWindow.characters.length >= 3 && MainWindow.characters[2].zustand != 'D') {
            MainWindow.selectedSurfaceCharacter = 2;
            MainWindow.pnlText.updateCharDetail(MainWindow.selectedSurfaceCharacter);
        }
        if (e.getKeyCode() == 52 && MainWindow.characters.length >= 4 && MainWindow.characters[3].zustand != 'D') {
            MainWindow.selectedSurfaceCharacter = 3;
            MainWindow.pnlText.updateCharDetail(MainWindow.selectedSurfaceCharacter);
        }
        if (e.getKeyCode() == 113) {
            this.lightTorch();
        }
        if (e.getKeyCode() == 114) {
            this.searchItem();
        }
        if (e.getKeyCode() == 116) {
            MainWindow.pnlText.showInventoryWaffen(MainWindow.inventoryWaffen);
        }
        if (e.getKeyCode() == 117) {
            MainWindow.pnlText.showInventoryRuestungen(MainWindow.inventoryRuestung);
        }
        if (e.getKeyCode() == 118) {
            MainWindow.pnlText.showInventoryItems(MainWindow.inventoryItems);
        }
        if (e.getKeyCode() == 119) {
            MainWindow.showDungeonMap();
        }
        if (e.getKeyCode() == 38) {
            yMov = 1;
        }
        if (e.getKeyCode() == 40) {
            yMov = -1;
        }
        if (e.getKeyCode() == 37) {
            xMov = 1;
        }
        if (e.getKeyCode() == 39) {
            xMov = -1;
        }
        if (e.getKeyCode() == 32) {
            if (this.renderMode == 0) {
                if (MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 's' || MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 'b' || MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 'k' || MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 'S') {
                    if (MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 's') {
                        this.startSoundPlayer(MainWindow.sndPlayerTowns);
                    }
                    if (MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 'b') {
                        this.startSoundPlayer(MainWindow.sndPlayerCastle);
                    }
                    if (MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 'k') {
                        this.startSoundPlayer(MainWindow.sndPlayerKloster);
                    }
                    if (MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 'S') {
                        this.startSoundPlayer(MainWindow.sndPlayerShrine);
                    }
                    this.enterSettlement(this.xMapPosition, this.yMapPosition);
                }
                if (MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 'h') {
                    this.enterDungeon(this.xMapPosition, this.yMapPosition);
                }
            }
            if (this.renderMode == 3) {
                if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition] == 'u') {
                    this.climbLadder();
                    this.paintComponent(this.getGraphics());
                    return;
                }
                if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition] == 'd') {
                    this.descentLadder();
                    this.paintComponent(this.getGraphics());
                    return;
                }
            }
        }
        if (!this.verifySpellkeys(e)) {
            if (Math.abs(xMov) > Math.abs(yMov)) {
                if (xMov > 0) {
                    this.scrollLeft();
                }
                if (xMov < 0) {
                    this.scrollRight();
                }
            } else {
                if (yMov > 0) {
                    this.scrollUp();
                }
                if (yMov < 0) {
                    this.scrollDown();
                }
            }
            if (this.renderMode == 0) {
                String tmpNameTile = "" + MainWindow.nameMap.map[this.xMapPosition][this.yMapPosition];
                NameMapTile tmpNameMapTile = MainWindow.nameMap.nameMapTiles.get(tmpNameTile);
                if (tmpNameMapTile.ambush > 0 && tmpNameMapTile.ambush < 100) {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("ambush_warn"), 4, new String[]{MainWindow.monsterTypes.get((Object)Integer.valueOf((int)tmpNameMapTile.monstTyp)).mz_name});
                }
                if (Math.random() * 99.0 + 1.0 < (double)tmpNameMapTile.ambush && tmpNameMapTile.ambush != 999) {
                    this.initTacticScreen(MainWindow.monsterTypes.get(tmpNameMapTile.monstTyp), true);
                }
                if (tmpNameMapTile.ambush == 999) {
                    long questSolved = 0L;
                    int i = 0;
                    while (i < MainWindow.inventoryItems.size()) {
                        Item tempItem = MainWindow.inventoryItems.get(i);
                        if (tempItem.effect.equals("solve_quest")) {
                            long param = Math.round(Double.parseDouble(tempItem.param) * 10.0);
                            questSolved += param;
                        }
                        ++i;
                    }
                    if (questSolved == 10L) {
                        this.initTacticScreen(MainWindow.monsterTypes.get(tmpNameMapTile.monstTyp), true);
                    } else {
                        MainWindow.pnlText.clearTextArea();
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("quest_not_solved"), 0, new String[]{"" + questSolved * 10L});
                    }
                }
            }
            if (this.renderMode == 3 && MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].tacticscreens != null) {
                Dungeonlevel tempDungLevel = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel];
                int i = 0;
                while (i < tempDungLevel.tacticscreens.length) {
                    char mapChar = tempDungLevel.map[this.xDungPosition][this.yDungPosition];
                    if (mapChar == tempDungLevel.tacticscreens[i].mapTile) {
                        int monstertype = tempDungLevel.monsters[(int)((double)tempDungLevel.monsters.length * Math.random())];
                        this.initTacticScreen(MainWindow.monsterTypes.get(monstertype), false);
                    }
                    ++i;
                }
                tempDungLevel = null;
            }
            if (xMapAlt != this.xMapPosition || yMapAlt != this.yMapPosition || this.renderMode == 3) {
                this.newRound();
            }
        } else {
            this.newRound();
        }
    }

    private boolean verifySpellkeys(KeyEvent e) {
        if (e.getKeyCode() == 65) {
            return this.doSpellcast('A');
        }
        if (e.getKeyCode() == 66) {
            return this.doSpellcast('B');
        }
        if (e.getKeyCode() == 67) {
            return this.doSpellcast('C');
        }
        if (e.getKeyCode() == 68) {
            return this.doSpellcast('D');
        }
        if (e.getKeyCode() == 69) {
            return this.doSpellcast('E');
        }
        if (e.getKeyCode() == 70) {
            return this.doSpellcast('F');
        }
        if (e.getKeyCode() == 71) {
            return this.doSpellcast('G');
        }
        if (e.getKeyCode() == 72) {
            return this.doSpellcast('H');
        }
        if (e.getKeyCode() == 73) {
            return this.doSpellcast('I');
        }
        if (e.getKeyCode() == 74) {
            return this.doSpellcast('J');
        }
        if (e.getKeyCode() == 75) {
            return this.doSpellcast('K');
        }
        if (e.getKeyCode() == 76) {
            return this.doSpellcast('L');
        }
        if (e.getKeyCode() == 77) {
            return this.doSpellcast('M');
        }
        if (e.getKeyCode() == 78) {
            return this.doSpellcast('N');
        }
        if (e.getKeyCode() == 79) {
            return this.doSpellcast('O');
        }
        if (e.getKeyCode() == 80) {
            return this.doSpellcast('P');
        }
        if (e.getKeyCode() == 81) {
            return this.doSpellcast('Q');
        }
        if (e.getKeyCode() == 82) {
            return this.doSpellcast('R');
        }
        if (e.getKeyCode() == 83) {
            return this.doSpellcast('S');
        }
        if (e.getKeyCode() == 84) {
            return this.doSpellcast('T');
        }
        if (e.getKeyCode() == 85) {
            return this.doSpellcast('U');
        }
        if (e.getKeyCode() == 86) {
            return this.doSpellcast('V');
        }
        if (e.getKeyCode() == 87) {
            return this.doSpellcast('W');
        }
        if (e.getKeyCode() == 88) {
            return this.doSpellcast('X');
        }
        if (e.getKeyCode() == 89) {
            return this.doSpellcast('Y');
        }
        return false;
    }

    public boolean doSpellcast(char spellkey) {
        Spell toCastSpell = HelpMethods.getSpell(spellkey);
        MainWindow.pnlText.clearTextArea();
        if (this.renderMode != 2) {
            MainWindow.pnlText.writeText(MainWindow.characters[MainWindow.selectedSurfaceCharacter].name);
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("char_casts"));
            MainWindow.pnlText.writeText(toCastSpell.name);
            boolean result = this.executeSpell(toCastSpell, MainWindow.selectedSurfaceCharacter);
            this.newRound();
            return result;
        }
        MainWindow.pnlText.writeText(MainWindow.characters[this.selectedCharacter].name);
        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("char_casts"));
        MainWindow.pnlText.writeText(toCastSpell.name);
        boolean result = this.executeSpell(toCastSpell, this.selectedCharacter);
        this.incTacticCharacters();
        return result;
    }

    private boolean executeSpell(Spell spell, int locSelectedChar) {
        if (spell.mp <= MainWindow.characters[locSelectedChar].aktMg) {
            boolean done;
            int aktTile;
            int mons;
            if (spell.effect.equalsIgnoreCase("light")) {
                this.light = spell.strength;
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("effect_light"));
                MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                MainWindow.pnlText.updateCharDetail(locSelectedChar);
                MainWindow.pnlText.updateCharacters();
            }
            if (spell.effect.equalsIgnoreCase("fire")) {
                if (this.renderMode == 2) {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("effect_fire"), new String[]{spell.name});
                    mons = -1;
                    int sicherheitscounter = 0;
                    while (mons == -1 && sicherheitscounter < 1000) {
                        int rnd = (int)(Math.random() * (double)MainWindow.tacticMonsters.length);
                        if (MainWindow.tacticMonsters[rnd] != null && MainWindow.tacticMonsters[rnd].hp > 0) {
                            mons = rnd;
                        }
                        ++sicherheitscounter;
                    }
                    if (mons == -1) {
                        System.out.println("Fehler : Bei Spruch 'fire' liess sich Monster nicht finden.");
                        System.exit(0);
                    }
                    this.renderHit = true;
                    this.xHit = MainWindow.tacticMonsters[mons].x;
                    this.yHit = MainWindow.tacticMonsters[mons].y;
                    MainWindow.sndPlayerSndMonsterHitted.playFromStart();
                    int schaden = 1 + (int)((double)spell.strength * Math.random());
                    MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("hitted")) + schaden);
                    MainWindow.tacticMonsters[mons].hp -= schaden;
                    if (MainWindow.tacticMonsters[mons].hp > 0) {
                        MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("rest_hp")) + MainWindow.tacticMonsters[mons].hp);
                    } else {
                        this.monsterKilled(mons, locSelectedChar);
                    }
                    MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                    MainWindow.pnlText.updateCharDetail(locSelectedChar);
                    MainWindow.pnlText.updateCharacters();
                } else {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("only_in_combat"));
                    MainWindow.characters[locSelectedChar].aktMg += spell.mp;
                }
            }
            if (spell.effect.equalsIgnoreCase("heal")) {
                int lowestMp = 32000;
                int toHealCharacter = -1;
                int i = 0;
                while (i < MainWindow.characters.length) {
                    if (MainWindow.characters[i].aktHp < lowestMp && MainWindow.characters[i].zustand != 'D') {
                        lowestMp = MainWindow.characters[i].aktHp;
                        toHealCharacter = i;
                    }
                    ++i;
                }
                MainWindow.characters[toHealCharacter].aktHp += spell.strength;
                if (MainWindow.characters[toHealCharacter].aktHp > MainWindow.characters[toHealCharacter].hp) {
                    MainWindow.characters[toHealCharacter].aktHp = MainWindow.characters[toHealCharacter].hp;
                }
                MainWindow.pnlText.writeText(String.valueOf(MainWindow.characters[toHealCharacter].name) + " " + MainWindow.screenTexts.get("effect_heal"));
                MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                MainWindow.pnlText.updateCharDetail(locSelectedChar);
                MainWindow.pnlText.updateCharacters();
            }
            if (spell.effect.equalsIgnoreCase("openChest")) {
                aktTile = 32;
                if (this.renderMode == 3) {
                    aktTile = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition];
                }
                if (this.renderMode == 1) {
                    aktTile = MainWindow.settlements[this.aktSettlement].map[this.xSettPosition][this.ySettPosition];
                }
                if (this.renderMode == 0) {
                    aktTile = MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition];
                }
                if (aktTile == 65 || aktTile == 66 || aktTile == 67 || aktTile == 68) {
                    int schatz;
                    boolean gecastet = false;
                    if (aktTile == 65 && spell.strength >= 25) {
                        schatz = 25 + (int)(Math.random() * 25.0);
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("chest_content"), new String[]{String.valueOf(schatz)});
                        this.gold += schatz;
                        if (this.renderMode == 3) {
                            MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition] = 46;
                        }
                        if (this.renderMode == 1) {
                            MainWindow.settlements[this.aktSettlement].map[this.xSettPosition][this.ySettPosition] = 46;
                        }
                        if (this.renderMode == 0) {
                            MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] = 46;
                        }
                        gecastet = true;
                    }
                    if (aktTile == 66 && spell.strength >= 50) {
                        schatz = 50 + (int)(Math.random() * 50.0);
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("chest_content"), new String[]{String.valueOf(schatz)});
                        this.gold += schatz;
                        if (this.renderMode == 3) {
                            MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition] = 46;
                        }
                        if (this.renderMode == 1) {
                            MainWindow.settlements[this.aktSettlement].map[this.xSettPosition][this.ySettPosition] = 46;
                        }
                        if (this.renderMode == 0) {
                            MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] = 46;
                        }
                        gecastet = true;
                    }
                    if (aktTile == 67 && spell.strength >= 75) {
                        schatz = 100 + (int)(Math.random() * 100.0);
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("chest_content"), new String[]{String.valueOf(schatz)});
                        this.gold += schatz;
                        if (this.renderMode == 3) {
                            MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition] = 46;
                        }
                        if (this.renderMode == 1) {
                            MainWindow.settlements[this.aktSettlement].map[this.xSettPosition][this.ySettPosition] = 46;
                        }
                        if (this.renderMode == 0) {
                            MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] = 46;
                        }
                        gecastet = true;
                    }
                    if (aktTile == 68 && spell.strength >= 100) {
                        schatz = 200 + (int)(Math.random() * 200.0);
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("chest_content"), new String[]{String.valueOf(schatz)});
                        this.gold += schatz;
                        if (this.renderMode == 3) {
                            MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition] = 46;
                        }
                        if (this.renderMode == 1) {
                            MainWindow.settlements[this.aktSettlement].map[this.xSettPosition][this.ySettPosition] = 46;
                        }
                        if (this.renderMode == 0) {
                            MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] = 46;
                        }
                        gecastet = true;
                    }
                    if (gecastet) {
                        MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                        MainWindow.pnlText.updateCharDetail(locSelectedChar);
                        MainWindow.pnlText.updateCharacters();
                        MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                    } else {
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("spell_too_weak"));
                    }
                } else {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("is_not_chest"));
                }
            }
            if (spell.effect.equalsIgnoreCase("openDoor") && this.renderMode == 3) {
                aktTile = 32;
                if (this.dungViewDirection == 3) {
                    aktTile = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition - 1];
                }
                if (this.dungViewDirection == 0) {
                    aktTile = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + 1][this.yDungPosition];
                }
                if (this.dungViewDirection == 1) {
                    aktTile = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition + 1];
                }
                if (this.dungViewDirection == 2) {
                    aktTile = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition - 1][this.yDungPosition];
                }
                if (aktTile == 49 || aktTile == 50 || aktTile == 51 || aktTile == 52) {
                    if (aktTile == 49 && spell.strength >= 25 || aktTile == 50 && spell.strength >= 50 || aktTile == 51 && spell.strength >= 75 || aktTile == 52 && spell.strength >= 100) {
                        if (this.dungViewDirection == 3) {
                            MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition - 1] = 46;
                        }
                        if (this.dungViewDirection == 0) {
                            MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + 1][this.yDungPosition] = 46;
                        }
                        if (this.dungViewDirection == 1) {
                            MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition + 1] = 46;
                        }
                        if (this.dungViewDirection == 2) {
                            MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition - 1][this.yDungPosition] = 46;
                        }
                        MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                    }
                } else {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("is_not_door"));
                    MainWindow.characters[locSelectedChar].aktMg += spell.mp;
                }
            }
            if (spell.effect.equalsIgnoreCase("lvDown")) {
                if (this.renderMode == 3) {
                    if (this.descentLadder()) {
                        MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                        MainWindow.pnlText.updateCharDetail(locSelectedChar);
                    }
                } else {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("only_in_dungeons"));
                }
            }
            if (spell.effect.equalsIgnoreCase("lvUp")) {
                if (this.renderMode == 3) {
                    MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                    this.climbLadder();
                    MainWindow.pnlText.updateCharDetail(locSelectedChar);
                } else {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("only_in_dungeons"));
                }
            }
            if (spell.effect.equalsIgnoreCase("exDng")) {
                if (this.renderMode == 3) {
                    MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                    this.leaveDungeon();
                    MainWindow.pnlText.updateCharDetail(locSelectedChar);
                } else {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("only_in_dungeons"));
                }
            }
            if (spell.effect.equalsIgnoreCase("fireAll")) {
                if (this.renderMode == 2) {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("effect_fire_all"), new String[]{spell.name});
                    MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                    mons = 0;
                    while (mons < MainWindow.tacticMonsters.length) {
                        if (MainWindow.tacticMonsters[mons] != null && MainWindow.tacticMonsters[mons].hp > 0) {
                            this.renderHit = true;
                            this.xHit = MainWindow.tacticMonsters[mons].x;
                            this.yHit = MainWindow.tacticMonsters[mons].y;
                            MainWindow.sndPlayerSndMonsterHitted.playFromStart();
                            int schaden = spell.strength + (int)((double)spell.strength * Math.random());
                            MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("hitted")) + schaden);
                            MainWindow.tacticMonsters[mons].hp -= schaden;
                            if (MainWindow.tacticMonsters[mons].hp > 0) {
                                MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("rest_hp")) + MainWindow.tacticMonsters[mons].hp);
                            } else {
                                this.monsterKilled(mons, locSelectedChar);
                            }
                            MainWindow.pnlText.updateCharDetail(locSelectedChar);
                            MainWindow.pnlText.updateCharacters();
                        }
                        ++mons;
                    }
                } else {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("only_in_combat"));
                    MainWindow.characters[locSelectedChar].aktMg += spell.mp;
                }
            }
            if (spell.effect.equalsIgnoreCase("cure")) {
                done = this.cureAll();
                if (done) {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("cured"));
                    MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                    MainWindow.pnlText.updateCharacters();
                } else {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_poison"));
                }
            }
            if (spell.effect.equalsIgnoreCase("resurr")) {
                done = this.resurrectAll();
                if (done) {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("resurrection"));
                    MainWindow.characters[locSelectedChar].aktMg -= spell.mp;
                    MainWindow.pnlText.updateCharacters();
                } else {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_dead"));
                }
            }
        } else {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("mp_too_low"));
        }
        return true;
    }

    private boolean poisonAll() {
        boolean done = false;
        int i = 0;
        while (i < MainWindow.characters.length) {
            if (MainWindow.characters[i].zustand != 'D') {
                MainWindow.characters[i].zustand = (char)80;
                done = true;
            }
            ++i;
        }
        return done;
    }

    private boolean healAll() {
        boolean done = false;
        int i = 0;
        while (i < MainWindow.characters.length) {
            if (MainWindow.characters[i].zustand != 'D') {
                MainWindow.characters[i].aktHp = MainWindow.characters[i].hp;
                done = true;
            }
            ++i;
        }
        return done;
    }

    private boolean cureAll() {
        boolean done = false;
        int i = 0;
        while (i < MainWindow.characters.length) {
            if (MainWindow.characters[i].zustand == 'P') {
                MainWindow.characters[i].zustand = (char)71;
                done = true;
            }
            ++i;
        }
        return done;
    }

    private boolean remagicAll() {
        boolean done = false;
        int i = 0;
        while (i < MainWindow.characters.length) {
            if (MainWindow.characters[i].zustand != 'D') {
                MainWindow.characters[i].aktMg = MainWindow.characters[i].mg;
                done = true;
            }
            ++i;
        }
        return done;
    }

    private boolean resurrectAll() {
        boolean done = false;
        int i = 0;
        while (i < MainWindow.characters.length) {
            if (MainWindow.characters[i].zustand == 'D') {
                MainWindow.characters[i].zustand = (char)71;
                MainWindow.characters[i].aktHp = MainWindow.characters[i].hp;
                done = true;
            }
            ++i;
        }
        return done;
    }

    private void monsterKilled(int monsterNr, int character) {
        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("enemy_killed"));
        MainWindow.characters[character].exp += MainWindow.tacticMonsters[monsterNr].type.exp;
        MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("experience")) + " + " + MainWindow.tacticMonsters[monsterNr].type.exp);
        int beute = (int)((double)MainWindow.tacticMonsters[monsterNr].type.maxGold * Math.random());
        this.gold += beute;
        MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("gold")) + " + " + beute);
        MainWindow.tacticMonsters[monsterNr] = null;
        MainWindow.pnlText.updateCharDetail(character);
        MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
        boolean isOneMonsSurvivig = false;
        int i = 0;
        while (i < MainWindow.tacticMonsters.length) {
            if (MainWindow.tacticMonsters[i] != null) {
                isOneMonsSurvivig = true;
            }
            ++i;
        }
        if (!isOneMonsSurvivig) {
            if (this.oldRenderMode == 3) {
                MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition] = 46;
                this.startSoundPlayer(MainWindow.sndPlayerDungeon);
            } else if (MainWindow.nameMap.map[this.xMapPosition][this.yMapPosition] == 'Z') {
                this.showVictoryScreen();
                MainWindow.nameMap.map[this.xMapPosition][this.yMapPosition] = 100;
                MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] = 46;
            } else {
                this.startSoundPlayer(MainWindow.sndPlayerWanderer);
                MainWindow.surfaceMonsters[this.aktSurfaceEnemy] = this.placeNewSurfaceMonster();
            }
            this.renderMode = this.oldRenderMode;
        }
    }

    private void showVictoryScreen() {
        String victoryText = MainWindow.screenTexts.get("dlgVictory");
        victoryText = victoryText.replace("#", "\n");
        JOptionPane.showMessageDialog(this, victoryText);
    }

    private void spawnNewMonster() {
        int i = 0;
        while (i < MainWindow.surfaceMonsters.length) {
            if (MainWindow.surfaceMonsters[i] == null) {
                MainWindow.surfaceMonsters[i] = this.placeNewSurfaceMonster();
            }
            ++i;
        }
    }

    private Monster placeNewSurfaceMonster() {
        int monsterType = 0;
        int x = 0;
        int y = 0;
        boolean found = false;
        while (!found) {
            x = (int)(Math.random() * (double)MainWindow.surfaceMap.width);
            y = (int)(Math.random() * (double)MainWindow.surfaceMap.height);
            char mapTile = MainWindow.surfaceMap.map[x][y];
            monsterType = (int)(Math.random() * (double)MainWindow.monsterTypes.size());
            if (MainWindow.monsterTypes.get((Object)Integer.valueOf((int)monsterType)).spawnarea != mapTile) continue;
            found = true;
        }
        return new Monster(MainWindow.monsterTypes.get(monsterType), x, y, 0, (int)((double)MainWindow.GAME_PARAM_LIFETIME_MONSTER * Math.random() * 2.0));
    }

    public void newRound() {
        if (this.renderMode == 0 || this.renderMode == 3) {
            int i;
            if (this.renderMode == 0) {
                if (Math.random() * (double)MainWindow.GAME_PARAM_NEW_MONSTER_EVERY_X_ROUNDS < 1.0) {
                    this.spawnNewMonster();
                }
                i = 0;
                while (i < MainWindow.surfaceMonsters.length) {
                    if (MainWindow.surfaceMonsters[i] != null) {
                        --MainWindow.surfaceMonsters[i].lifetime;
                        if (MainWindow.surfaceMonsters[i].lifetime < 0) {
                            MainWindow.surfaceMonsters[i] = null;
                        }
                    }
                    ++i;
                }
            }
            if (Math.random() * (double)MainWindow.GAME_PARAM_EAT_FOOD_EVERY_X_MOVE < 1.0) {
                --this.food;
            }
            if (this.food < 0) {
                this.food = 0;
                i = 0;
                while (i < MainWindow.characters.length) {
                    if (MainWindow.characters[i].aktHp > 0) {
                        MainWindow.characters[i].aktHp -= MainWindow.GAME_PARAM_HPLOST_STARVING;
                    }
                    if (MainWindow.characters[i].aktHp <= 0 && !this.killCharacter(i)) {
                        MainWindow.sndPlayerCombat.stop();
                        this.gameLost();
                    }
                    MainWindow.pnlText.updateCharacters();
                    ++i;
                }
            }
            i = 0;
            while (i < MainWindow.characters.length) {
                if (Math.random() * (double)MainWindow.GAME_PARAM_HPLOST_EVERY_X_POISONMOVE < 1.0 && MainWindow.characters[i].zustand == 'P' && MainWindow.characters[i].zustand != 'D') {
                    --MainWindow.characters[i].aktHp;
                    if (MainWindow.characters[i].aktHp <= 0 && !this.killCharacter(i)) {
                        MainWindow.sndPlayerCombat.stop();
                        this.gameLost();
                    }
                }
                if (Math.random() * (double)MainWindow.GAME_PARAM_HPHEAL_EVERY_X_MOVE < 1.0 && MainWindow.characters[i].aktHp < MainWindow.characters[i].hp && MainWindow.characters[i].zustand != 'D') {
                    ++MainWindow.characters[i].aktHp;
                }
                if (Math.random() * (double)MainWindow.GAME_PARAM_MPHEAL_EVERY_X_MOVE < 1.0 && MainWindow.characters[i].aktMg < MainWindow.characters[i].mg && MainWindow.characters[i].zustand != 'D') {
                    ++MainWindow.characters[i].aktMg;
                    MainWindow.pnlText.updateCharacters();
                    MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                }
                MainWindow.pnlText.updateCharacters();
                MainWindow.pnlText.updateCharDetail(MainWindow.selectedSurfaceCharacter);
                MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                ++i;
            }
            if (this.renderMode == 0) {
                i = 0;
                while (i < MainWindow.surfaceMonsters.length) {
                    if (MainWindow.surfaceMonsters[i] != null) {
                        this.moveSurfaceMonster(i);
                    }
                    ++i;
                }
            }
        }
    }

    public void doKeyMoveTactic(KeyEvent e) {
        int xMov = 0;
        int yMov = 0;
        if (e.getKeyCode() == 38 && !this.getBewegungIsSchuss(0)) {
            yMov = 1;
        }
        if (e.getKeyCode() == 40 && !this.getBewegungIsSchuss(2)) {
            yMov = -1;
        }
        if (e.getKeyCode() == 37 && !this.getBewegungIsSchuss(3)) {
            xMov = 1;
        }
        if (e.getKeyCode() == 39 && !this.getBewegungIsSchuss(1)) {
            xMov = -1;
        }
        if (e.getKeyCode() == 32) {
            this.incTacticCharacters();
            this.paintComponent(this.getGraphics());
        }
        if (!(this.verifySpellkeys(e) || xMov == 0 && yMov == 0)) {
            this.doMoveTactic(xMov, yMov);
        }
    }

    private boolean getBewegungIsSchuss(int direction) {
        int x;
        int i;
        int y;
        Character chr = MainWindow.characters[this.selectedCharacter];
        if (MainWindow.professions[chr.profession].waffenTyp != 3) {
            return false;
        }
        TacticScreen tempTacScreen = null;
        tempTacScreen = this.oldRenderMode == 3 ? MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].tacticscreens[this.aktTacticScreen] : MainWindow.tacticScreens[this.aktTacticScreen];
        if (direction == 0) {
            y = chr.yTactic;
            while (y >= 0) {
                if (!this.getTileDurchschaubar(1, tempTacScreen.map[chr.xTactic][y])) {
                    return false;
                }
                i = 0;
                while (i < MainWindow.tacticMonsters.length) {
                    if (MainWindow.tacticMonsters[i] != null && MainWindow.tacticMonsters[i].hp >= 0 && MainWindow.tacticMonsters[i].x == chr.xTactic && MainWindow.tacticMonsters[i].y == y) {
                        this.doShootAtMonster(chr, i, direction);
                        return true;
                    }
                    ++i;
                }
                --y;
            }
        }
        if (direction == 1) {
            x = chr.xTactic;
            while (x < tempTacScreen.map[0].length) {
                if (!this.getTileDurchschaubar(1, tempTacScreen.map[x][chr.yTactic])) {
                    return false;
                }
                i = 0;
                while (i < MainWindow.tacticMonsters.length) {
                    if (MainWindow.tacticMonsters[i] != null && MainWindow.tacticMonsters[i].hp >= 0 && MainWindow.tacticMonsters[i].x == x && MainWindow.tacticMonsters[i].y == chr.yTactic) {
                        this.doShootAtMonster(chr, i, direction);
                        return true;
                    }
                    ++i;
                }
                ++x;
            }
        }
        if (direction == 2) {
            y = chr.yTactic;
            while (y < tempTacScreen.map.length) {
                if (!this.getTileDurchschaubar(1, tempTacScreen.map[chr.xTactic][y])) {
                    return false;
                }
                i = 0;
                while (i < MainWindow.tacticMonsters.length) {
                    if (MainWindow.tacticMonsters[i] != null && MainWindow.tacticMonsters[i].hp >= 0 && MainWindow.tacticMonsters[i].x == chr.xTactic && MainWindow.tacticMonsters[i].y == y) {
                        this.doShootAtMonster(chr, i, direction);
                        return true;
                    }
                    ++i;
                }
                ++y;
            }
        }
        if (direction == 3) {
            x = chr.xTactic;
            while (x > 0) {
                if (!this.getTileDurchschaubar(1, tempTacScreen.map[x][chr.yTactic])) {
                    return false;
                }
                i = 0;
                while (i < MainWindow.tacticMonsters.length) {
                    if (MainWindow.tacticMonsters[i] != null && MainWindow.tacticMonsters[i].hp >= 0 && MainWindow.tacticMonsters[i].x == x && MainWindow.tacticMonsters[i].y == chr.yTactic) {
                        this.doShootAtMonster(chr, i, direction);
                        return true;
                    }
                    ++i;
                }
                --x;
            }
        }
        return false;
    }

    private void doShootAtMonster(Character chr, int mons, int direction) {
        this.renderHit = false;
        this.renderEnemyHit = false;
        MainWindow.pnlText.clearTextArea();
        Waffe angrWaffe = HelpMethods.getWaffe(MainWindow.professions[chr.profession].waffenTyp, chr.waffe);
        String strAngrWaffe = angrWaffe.typ == 0 ? MainWindow.professions[chr.profession].noweapon : angrWaffe.name;
        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("char_att_monst"), new String[]{chr.name, strAngrWaffe});
        double charDxVal = (double)chr.dx * Math.random();
        double monsDxVal = (double)MainWindow.tacticMonsters[mons].type.dx * Math.random();
        if (charDxVal > monsDxVal) {
            this.renderHit = true;
            this.xHit = MainWindow.tacticMonsters[mons].x;
            this.yHit = MainWindow.tacticMonsters[mons].y;
            MainWindow.sndPlayerSndMonsterHitted.playFromStart();
            int schaden = (int)((double)chr.st / 20.0 * Math.random() + (double)HelpMethods.getWaffe((int)MainWindow.professions[chr.profession].waffenTyp, (int)chr.waffe).st);
            MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("hitted")) + schaden);
            MainWindow.tacticMonsters[mons].hp -= schaden;
            if (MainWindow.tacticMonsters[mons].hp > 0) {
                MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("rest_hp")) + MainWindow.tacticMonsters[mons].hp);
            } else {
                this.monsterKilled(mons, this.selectedCharacter);
            }
        } else {
            MainWindow.sndPlayerSndMonsterNotHitted.playFromStart();
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("missed"));
        }
        MainWindow.sndPlayerSndMonsterHitted.playFromStart();
        this.incTacticCharacters();
    }

    private void doMoveTactic(int xMov, int yMov) {
        this.renderHit = false;
        this.renderEnemyHit = false;
        MainWindow.pnlText.clearTextArea();
        if (Math.abs(xMov) > Math.abs(yMov)) {
            if (xMov > 0) {
                this.moveTacticSingleCharacter(-1, 0);
            }
            if (xMov < 0) {
                this.moveTacticSingleCharacter(1, 0);
            }
        } else {
            if (yMov > 0) {
                this.moveTacticSingleCharacter(0, -1);
            }
            if (yMov < 0) {
                this.moveTacticSingleCharacter(0, 1);
            }
        }
    }

    public void incTacticCharacters() {
        if (!this.getIsOneCharSurviving()) {
            this.gameLost();
        } else {
            ++this.selectedCharacter;
            if (this.selectedCharacter > MainWindow.characters.length - 1) {
                this.selectedCharacter = 0;
                this.moveTacticMonsters();
            }
            MainWindow.pnlText.listCharacter.setSelectedIndex(this.selectedCharacter);
            if (MainWindow.characters[this.selectedCharacter].aktHp <= 0) {
                this.incTacticCharacters();
            }
        }
    }

    private boolean moveTacticSingleCharacter(int xs, int ys) {
        Integer[] takMCColl;
        boolean inc = true;
        Character selChar = MainWindow.characters[this.selectedCharacter];
        int xAlt = selChar.xTactic;
        int yAlt = selChar.yTactic;
        selChar.xTactic += xs;
        selChar.yTactic += ys;
        if (selChar.xTactic < 0 || selChar.xTactic > this.zoom - 1) {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_go"), new String[]{selChar.name});
            selChar.xTactic = xAlt;
            inc = false;
        }
        if (selChar.yTactic < 0 || selChar.yTactic > this.zoom - 1) {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_go"), new String[]{selChar.name});
            selChar.yTactic = yAlt;
            inc = false;
        }
        try {
            char chrField;
            char c = chrField = this.oldRenderMode == 0 ? MainWindow.tacticScreens[this.aktTacticScreen].map[selChar.xTactic][selChar.yTactic] : MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].tacticscreens[this.aktTacticScreen].map[selChar.xTactic][selChar.yTactic];
            if (!this.getTileBetretbar(1, chrField)) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_go"), new String[]{selChar.name});
                selChar.xTactic = xAlt;
                selChar.yTactic = yAlt;
                inc = false;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            selChar.xTactic = xAlt;
            selChar.yTactic = yAlt;
            inc = false;
        }
        if (this.takCharCharCollision()[0] != null) {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_go"), new String[]{selChar.name});
            selChar.xTactic = xAlt;
            selChar.yTactic = yAlt;
            inc = false;
        }
        if ((takMCColl = this.takMonsCharCollision())[0] != null) {
            Waffe angrWaffe = HelpMethods.getWaffe(MainWindow.professions[selChar.profession].waffenTyp, selChar.waffe);
            String strAngrWaffe = angrWaffe.typ == 0 ? MainWindow.professions[selChar.profession].noweapon : angrWaffe.name;
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("char_att_monst"), new String[]{selChar.name, strAngrWaffe});
            double charDxVal = (double)selChar.dx * Math.random();
            double monsDxVal = (double)MainWindow.tacticMonsters[takMCColl[0].intValue()].type.dx * Math.random();
            if (charDxVal > monsDxVal) {
                this.renderHit = true;
                this.xHit = MainWindow.tacticMonsters[takMCColl[0].intValue()].x;
                this.yHit = MainWindow.tacticMonsters[takMCColl[0].intValue()].y;
                MainWindow.sndPlayerSndMonsterHitted.playFromStart();
                int schaden = (int)((double)selChar.st / 20.0 + (double)selChar.st / 20.0 * Math.random() + (double)HelpMethods.getWaffe((int)MainWindow.professions[selChar.profession].waffenTyp, (int)selChar.waffe).st);
                MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("hitted")) + schaden);
                MainWindow.tacticMonsters[takMCColl[0].intValue()].hp -= schaden;
                if (MainWindow.tacticMonsters[takMCColl[0].intValue()].hp > 0) {
                    MainWindow.pnlText.writeText(String.valueOf(MainWindow.screenTexts.get("rest_hp")) + MainWindow.tacticMonsters[takMCColl[0].intValue()].hp);
                } else {
                    this.monsterKilled(takMCColl[0], this.selectedCharacter);
                }
            } else {
                MainWindow.sndPlayerSndMonsterNotHitted.playFromStart();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("missed"));
            }
            MainWindow.sndPlayerSndMonsterHitted.playFromStart();
            selChar.xTactic = xAlt;
            selChar.yTactic = yAlt;
            inc = true;
        }
        if (selChar.xTactic != xAlt || selChar.yTactic != yAlt) {
            if (selChar.xTactic > xAlt) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("char_go_e"), new String[]{selChar.name});
            }
            if (selChar.xTactic < xAlt) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("char_go_w"), new String[]{selChar.name});
            }
            if (selChar.yTactic > yAlt) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("char_go_s"), new String[]{selChar.name});
            }
            if (selChar.yTactic < yAlt) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("char_go_n"), new String[]{selChar.name});
            }
        }
        log.logTacCharMov(selChar, xAlt, yAlt);
        if (inc) {
            this.incTacticCharacters();
        }
        this.paintComponent(this.getGraphics());
        return inc;
    }

    private void moveTacticMonsters() {
        int i = 0;
        while (i < MainWindow.tacticMonsters.length) {
            this.moveTacticMonster(i);
            ++i;
        }
    }

    private void moveTacticMonster(int monstNr) {
        Monster monst = MainWindow.tacticMonsters[monstNr];
        TacticScreen tempTacScreen = null;
        tempTacScreen = this.oldRenderMode == 3 ? MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].tacticscreens[this.aktTacticScreen] : MainWindow.tacticScreens[this.aktTacticScreen];
        if (monst != null && (monst.type.mg == 0 || Math.random() < 0.8)) {
            boolean hasMoved = false;
            long direction = 0L;
            while (!hasMoved) {
                Integer[] mcCollision;
                Integer[] mmCollision;
                char chrField;
                int xalt = monst.x;
                int yalt = monst.y;
                if (Math.random() > 0.2) {
                    if (Math.random() > 0.5) {
                        if (monst.x < MainWindow.characters[monst.targetEnemy].xTactic) {
                            direction = 1L;
                        }
                        if (monst.x > MainWindow.characters[monst.targetEnemy].xTactic) {
                            direction = 3L;
                        }
                        if (monst.y < MainWindow.characters[monst.targetEnemy].yTactic) {
                            direction = 2L;
                        }
                        if (monst.y > MainWindow.characters[monst.targetEnemy].yTactic) {
                            direction = 0L;
                        }
                    } else {
                        if (monst.y < MainWindow.characters[monst.targetEnemy].yTactic) {
                            direction = 2L;
                        }
                        if (monst.y > MainWindow.characters[monst.targetEnemy].yTactic) {
                            direction = 0L;
                        }
                        if (monst.x < MainWindow.characters[monst.targetEnemy].xTactic) {
                            direction = 1L;
                        }
                        if (monst.x > MainWindow.characters[monst.targetEnemy].xTactic) {
                            direction = 3L;
                        }
                    }
                } else {
                    direction = Math.round(Math.random() * 4.0);
                }
                if (direction == 0L) {
                    --monst.y;
                }
                if (direction == 1L) {
                    ++monst.x;
                }
                if (direction == 2L) {
                    ++monst.y;
                }
                if (direction == 3L) {
                    --monst.x;
                }
                if (monst.x > tempTacScreen.map[0].length - 1 || monst.x < 0 || monst.y > tempTacScreen.map.length - 1 || monst.y < 0) {
                    monst.x = xalt;
                    monst.y = yalt;
                    hasMoved = false;
                }
                if (!this.getTileBetretbar(1, chrField = tempTacScreen.map[monst.x][monst.y])) {
                    monst.x = xalt;
                    monst.y = yalt;
                    hasMoved = false;
                }
                if ((mmCollision = this.takMonsMonsCollision())[0] != null) {
                    monst.x = xalt;
                    monst.y = yalt;
                    log.logTacMonsMonsColl(mmCollision, monst, xalt, yalt);
                    hasMoved = monst.x == xalt || monst.y == yalt;
                }
                if ((mcCollision = this.takMonsCharCollision())[0] != null) {
                    int charGetroffen = mcCollision[1];
                    if (monst.type.poison && Math.random() * (double)MainWindow.GAME_PARAM_POISON_EVERY_X_HIT < 1.0) {
                        MainWindow.characters[charGetroffen].zustand = (char)80;
                    }
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("monst_att_char"), new String[]{monst.type.name, monst.type.attack, MainWindow.characters[charGetroffen].name});
                    MainWindow.sndPlayerSndMonsterAttack.playFromStart();
                    double monstDxVal = (double)monst.type.dx * Math.random();
                    double charRuestVal = (double)MainWindow.characters[charGetroffen].ruestung * Math.random();
                    if (monstDxVal > charRuestVal) {
                        this.xEnemyHit = MainWindow.characters[charGetroffen].xTactic;
                        this.yEnemyHit = MainWindow.characters[charGetroffen].yTactic;
                        this.renderEnemyHit = true;
                        int monstTrefferVal = 1 + (int)((double)monst.type.st * Math.random());
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("monst_hits_char"), new String[]{String.valueOf(monstTrefferVal)});
                        MainWindow.characters[charGetroffen].aktHp -= monstTrefferVal;
                        if (MainWindow.characters[charGetroffen].aktHp <= 0) {
                            if (this.killCharacter(charGetroffen)) {
                                int neuesZiel = -1;
                                while (neuesZiel == -1) {
                                    neuesZiel = (int)((double)MainWindow.characters.length * Math.random());
                                    if (MainWindow.characters[neuesZiel].aktHp > 0) continue;
                                    neuesZiel = -1;
                                }
                                monst.targetEnemy = neuesZiel;
                            } else {
                                MainWindow.sndPlayerCombat.stop();
                                this.gameLost();
                            }
                        }
                        MainWindow.pnlText.updateCharacters();
                        MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                    } else {
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("armor_defends"));
                        MainWindow.sndPlayerSndDefend.playFromStart();
                    }
                    monst.x = xalt;
                    monst.y = yalt;
                    hasMoved = true;
                }
                if (monst.x != xalt || monst.y != yalt) {
                    MainWindow.pnlText.writeTacMonsterMove((int)direction, monst);
                    log.logTacMonsMov(monstNr, monst);
                }
                if (mmCollision[0] != null || mcCollision[0] != null) continue;
                hasMoved = true;
            }
        }
    }

    private void gameLost() {
        this.startSoundPlayer(MainWindow.sndPlayerDead);
        this.paintAll(this.getGraphics());
        MainWindow.pnlText.updateCharacters();
        MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
        JOptionPane.showMessageDialog(this, MainWindow.screenTexts.get("dlgGameLost").replace("#", "\n"));
        this.renderMode = 0;
        this.startSoundPlayer(MainWindow.sndPlayerWanderer);
        MainWindow.startNewGame(MainWindow.xmlDoc);
    }

    private boolean killCharacter(int c) {
        MainWindow.characters[c].zustand = (char)68;
        return this.getIsOneCharSurviving();
    }

    private boolean getIsOneCharSurviving() {
        boolean isOneSurviving = false;
        int i = 0;
        while (i < MainWindow.characters.length) {
            if (MainWindow.characters[i].aktHp > 0) {
                isOneSurviving = true;
            }
            ++i;
        }
        return isOneSurviving;
    }

    private Integer[] takMonsMonsCollision() {
        int i1 = 0;
        while (i1 < MainWindow.tacticMonsters.length) {
            if (MainWindow.tacticMonsters[i1] != null && MainWindow.tacticMonsters[i1].hp > 0) {
                int i2 = 0;
                while (i2 < MainWindow.tacticMonsters.length) {
                    if (MainWindow.tacticMonsters[i2] != null && MainWindow.tacticMonsters[i2].hp > 0 && MainWindow.tacticMonsters[i1].x == MainWindow.tacticMonsters[i2].x && MainWindow.tacticMonsters[i1].y == MainWindow.tacticMonsters[i2].y && i1 != i2) {
                        return new Integer[]{i1, i2};
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        return new Integer[2];
    }

    private Integer[] takMonsCharCollision() {
        int i1 = 0;
        while (i1 < MainWindow.tacticMonsters.length) {
            if (MainWindow.tacticMonsters[i1] != null && MainWindow.tacticMonsters[i1].hp > 0) {
                int i2 = 0;
                while (i2 < MainWindow.characters.length) {
                    if (MainWindow.characters[i2].aktHp > 0 && MainWindow.tacticMonsters[i1].x == MainWindow.characters[i2].xTactic && MainWindow.tacticMonsters[i1].y == MainWindow.characters[i2].yTactic) {
                        return new Integer[]{i1, i2};
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        return new Integer[2];
    }

    private Integer[] takCharCharCollision() {
        int i1 = 0;
        while (i1 < MainWindow.characters.length) {
            if (MainWindow.characters[i1].aktHp > 0) {
                int i2 = 0;
                while (i2 < MainWindow.characters.length) {
                    if (MainWindow.characters[i2].aktHp > 0 && MainWindow.characters[i1].xTactic == MainWindow.characters[i2].xTactic && MainWindow.characters[i1].yTactic == MainWindow.characters[i2].yTactic && i1 != i2) {
                        return new Integer[]{i1, i2};
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        return new Integer[2];
    }

    private void moveSurfaceMonster(int monstNr) {
        Monster monst = MainWindow.surfaceMonsters[monstNr];
        int xAlt = monst.x;
        int yAlt = monst.y;
        int i = 0;
        while (xAlt == monst.x && yAlt == monst.y && i < 10) {
            ++i;
            if (monst.x > this.xMapPosition) {
                --monst.x;
            }
            if (monst.x < this.xMapPosition) {
                ++monst.x;
            }
            if (monst.y > this.yMapPosition) {
                --monst.y;
            }
            if (monst.y < this.yMapPosition) {
                ++monst.y;
            }
            if (Math.random() < 0.2) {
                monst.x = xAlt;
                monst.y = yAlt;
                monst.x = Math.random() < 0.5 ? --monst.x : ++monst.x;
                monst.y = Math.random() < 0.5 ? --monst.y : ++monst.y;
            }
            if (Math.random() > 0.5) {
                monst.x = xAlt;
            } else {
                monst.y = yAlt;
            }
            if (monst.x < 0 || monst.x > MainWindow.surfaceMap.width - 1) {
                monst.x = xAlt;
            }
            if (monst.y < 0 || monst.y > MainWindow.surfaceMap.height - 1) {
                monst.y = yAlt;
            }
            if (this.monsterCollision(monst.x, monst.y, monstNr) || !this.getTileBetretbar(0, MainWindow.surfaceMap.map[monst.x][monst.y])) {
                monst.x = xAlt;
                monst.y = yAlt;
            }
            if (monst.x != this.xMapPosition || monst.y != this.yMapPosition) continue;
            this.aktSurfaceEnemy = monstNr;
            this.initTacticScreen(monst.type, false);
        }
    }

    private void initTacticScreen(MonsterType monsterType, boolean ambush) {
        int i;
        if (this.renderMode != 2) {
            this.oldRenderMode = this.renderMode;
        }
        this.renderMode = 2;
        this.renderHit = false;
        this.renderEnemyHit = false;
        int i2 = MainWindow.characters.length - 1;
        while (i2 >= 0) {
            if (MainWindow.characters[i2].zustand != 'D') {
                this.selectedCharacter = i2;
            }
            --i2;
        }
        MainWindow.pnlText.listCharacter.setSelectedIndex(this.selectedCharacter);
        String tmpNameMapTile = "" + MainWindow.nameMap.map[this.xMapPosition][this.yMapPosition];
        TacticScreen tempTac = null;
        if (this.oldRenderMode == 3) {
            Dungeonlevel tempDungLevel = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel];
            int i3 = 0;
            while (i3 < tempDungLevel.tacticscreens.length) {
                char mapChar = tempDungLevel.map[this.xDungPosition][this.yDungPosition];
                if (mapChar == tempDungLevel.tacticscreens[i3].mapTile) {
                    this.aktTacticScreen = i3;
                    tempTac = tempDungLevel.tacticscreens[this.aktTacticScreen];
                    this.zoom = tempTac.mapWidth;
                }
                this.resizeImages();
                ++i3;
            }
            tempDungLevel = null;
        } else {
            int iTac;
            this.aktTacticScreen = 0;
            if (ambush) {
                iTac = 0;
                while (iTac < MainWindow.tacticScreens.length) {
                    if (tmpNameMapTile.equals(MainWindow.tacticScreens[iTac].name)) {
                        this.aktTacticScreen = iTac;
                    }
                    ++iTac;
                }
            } else {
                iTac = 0;
                while (iTac < MainWindow.tacticScreens.length) {
                    if (MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == MainWindow.tacticScreens[iTac].mapTile) {
                        this.aktTacticScreen = iTac;
                    }
                    ++iTac;
                }
            }
            tempTac = MainWindow.tacticScreens[this.aktTacticScreen];
            this.zoom = tempTac.mapWidth;
            this.resizeImages();
        }
        MainWindow.characters[0].xTactic = tempTac.c1x;
        MainWindow.characters[0].yTactic = tempTac.c1y;
        MainWindow.characters[1].xTactic = tempTac.c2x;
        MainWindow.characters[1].yTactic = tempTac.c2y;
        MainWindow.characters[2].xTactic = tempTac.c3x;
        MainWindow.characters[2].yTactic = tempTac.c3y;
        MainWindow.characters[3].xTactic = tempTac.c4x;
        MainWindow.characters[3].yTactic = tempTac.c4y;
        int i4 = 0;
        while (i4 < MainWindow.tacticMonsters.length) {
            MainWindow.tacticMonsters[i4] = null;
            ++i4;
        }
        int monAnz = 0;
        if (this.oldRenderMode == 3) {
            Dungeonlevel tempDungLevel = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel];
            monAnz = tempDungLevel.monsterCount;
        } else if (ambush && MainWindow.nameMap.nameMapTiles.get((Object)tmpNameMapTile).monstCnt > 0) {
            monAnz = MainWindow.nameMap.nameMapTiles.get((Object)tmpNameMapTile).monstCnt;
        } else {
            int lvSum = 0;
            i = 0;
            while (i < MainWindow.characters.length) {
                lvSum += MainWindow.characters[i].level;
                ++i;
            }
            if (lvSum < 4) {
                monAnz = 1 + (int)(Math.random() * 3.0);
            }
            if (lvSum >= 4) {
                monAnz = 1 + (int)(Math.random() * 4.0);
            }
            if (lvSum >= 8) {
                monAnz = 1 + (int)(Math.random() * 5.0);
            }
            if (lvSum >= 12) {
                monAnz = 1 + (int)(Math.random() * 6.0);
            }
            if (lvSum >= 16) {
                monAnz = 2 + (int)(Math.random() * 6.0);
            }
            if (lvSum >= 20) {
                monAnz = 3 + (int)(Math.random() * 6.0);
            }
            if (lvSum >= 24) {
                monAnz = 4 + (int)(Math.random() * 7.0);
            }
            if (lvSum >= 28) {
                monAnz = 5 + (int)(Math.random() * 7.0);
            }
            if (lvSum >= 32) {
                monAnz = 6 + (int)(Math.random() * 7.0);
            }
        }
        boolean[] monPosBisher = new boolean[12];
        i = 0;
        while (i < 12) {
            monPosBisher[i] = false;
            ++i;
        }
        i = 0;
        while (i < monAnz) {
            int monPos;
            int x = 0;
            int y = 0;
            while (monPosBisher[monPos = (int)(Math.random() * 12.0)]) {
            }
            monPosBisher[monPos] = true;
            if (monPos == 0) {
                x = tempTac.m1x;
                y = tempTac.m1y;
            }
            if (monPos == 1) {
                x = tempTac.m2x;
                y = tempTac.m2y;
            }
            if (monPos == 2) {
                x = tempTac.m3x;
                y = tempTac.m3y;
            }
            if (monPos == 3) {
                x = tempTac.m4x;
                y = tempTac.m4y;
            }
            if (monPos == 4) {
                x = tempTac.m5x;
                y = tempTac.m5y;
            }
            if (monPos == 5) {
                x = tempTac.m6x;
                y = tempTac.m6y;
            }
            if (monPos == 6) {
                x = tempTac.m7x;
                y = tempTac.m7y;
            }
            if (monPos == 7) {
                x = tempTac.m8x;
                y = tempTac.m8y;
            }
            if (monPos == 8) {
                x = tempTac.m9x;
                y = tempTac.m9y;
            }
            if (monPos == 9) {
                x = tempTac.m10x;
                y = tempTac.m10y;
            }
            if (monPos == 10) {
                x = tempTac.m11x;
                y = tempTac.m11y;
            }
            if (monPos == 11) {
                x = tempTac.m12x;
                y = tempTac.m12y;
            }
            int enemyTarget = (int)Math.round(Math.random() * 3.0);
            while (MainWindow.characters[enemyTarget].hp == 0) {
                enemyTarget = (int)Math.round(Math.random() * 3.0);
            }
            MainWindow.tacticMonsters[i] = new Monster(monsterType, x, y, enemyTarget, 0);
            ++i;
        }
        this.startSoundPlayer(MainWindow.sndPlayerCombat);
        tempTac = null;
        this.paintComponent(this.getGraphics());
    }

    private boolean monsterCollision(int x, int y, int monstNr) {
        if (x < 0 || y < 0 || x > MainWindow.surfaceMap.width - 1 || y > MainWindow.surfaceMap.height - 1) {
            return false;
        }
        int i = 0;
        while (i < MainWindow.surfaceMonsters.length) {
            if (i != monstNr && MainWindow.surfaceMonsters[i] != null && MainWindow.surfaceMonsters[i].x == x && MainWindow.surfaceMonsters[i].y == y) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void leaveSettlement() {
        this.renderMode = 0;
        this.paintComponent(this.getGraphics());
        this.startSoundPlayer(MainWindow.sndPlayerWanderer);
        System.gc();
    }

    private void enterSettlement(int x, int y) {
        this.aktSettlement = this.getSettlementByPosition(x, y);
        if (this.aktSettlement != -1) {
            MainWindow.pnlText.clearTextArea();
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("enter_location"), new String[]{MainWindow.settlements[this.aktSettlement].name});
            if (MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition] == 'S') {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("shrine_heal"));
                int i = 0;
                while (i < MainWindow.characters.length) {
                    if (MainWindow.characters[i].zustand != 'D') {
                        MainWindow.characters[i].aktHp = MainWindow.characters[i].hp;
                        MainWindow.characters[i].aktMg = MainWindow.characters[i].mg;
                        MainWindow.characters[i].zustand = (char)71;
                        int newLevel = 0;
                        int i2 = 0;
                        while (i2 < MainWindow.professions.length) {
                            if (MainWindow.characters[i].profession == i2) {
                                Profession prof = MainWindow.professions[i2];
                                int i3 = 0;
                                while (i3 < prof.expLevel.length) {
                                    if (MainWindow.characters[i].exp > prof.expLevel[i3]) {
                                        newLevel = i3 + 1;
                                    }
                                    ++i3;
                                }
                            }
                            ++i2;
                        }
                        if (newLevel > MainWindow.characters[i].level && MainWindow.characters[i].exp < 99999) {
                            MainWindow.pnlText.writeText(MainWindow.characters[i].name);
                            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("new_level"));
                            MainWindow.pnlText.writeText(String.valueOf(MainWindow.professions[MainWindow.characters[i].profession].level[newLevel]) + "# #");
                            MainWindow.characters[i].level = newLevel;
                            MainWindow.characters[i].hp = MainWindow.classes[MainWindow.characters[i].klasse].hp * newLevel;
                            MainWindow.characters[i].st = MainWindow.classes[MainWindow.characters[i].klasse].st * newLevel;
                            MainWindow.characters[i].dx = MainWindow.classes[MainWindow.characters[i].klasse].dx * newLevel;
                            MainWindow.characters[i].mg = MainWindow.classes[MainWindow.characters[i].klasse].mg * newLevel;
                            if (MainWindow.professions[MainWindow.characters[i].profession].growdouble.contains("hp")) {
                                MainWindow.characters[i].hp *= 2;
                            }
                            if (MainWindow.professions[MainWindow.characters[i].profession].growdouble.contains("st")) {
                                MainWindow.characters[i].st *= 2;
                            }
                            if (MainWindow.professions[MainWindow.characters[i].profession].growdouble.contains("dx")) {
                                MainWindow.characters[i].dx *= 2;
                            }
                            if (MainWindow.professions[MainWindow.characters[i].profession].growdouble.contains("mg")) {
                                MainWindow.characters[i].mg *= 2;
                            }
                        }
                    }
                    ++i;
                }
                MainWindow.pnlText.updateCharacters();
                MainWindow.pnlText.updateCharDetail(MainWindow.selectedSurfaceCharacter);
            }
            this.renderMode = 1;
            this.xSettPosition = MainWindow.settlements[this.aktSettlement].startposx;
            this.ySettPosition = MainWindow.settlements[this.aktSettlement].startposy;
            this.paintComponent(this.getGraphics());
        }
    }

    private int getSettlementByPosition(int x, int y) {
        int result = -1;
        int i = 0;
        while (i < MainWindow.settlements.length) {
            if (MainWindow.settlements[i].posx == x && MainWindow.settlements[i].posy == y) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private int getDungeonByPosition(int x, int y) {
        int result = -1;
        int i = 0;
        while (i < MainWindow.dungeons.length) {
            if (MainWindow.dungeons[i].posx == x && MainWindow.dungeons[i].posy == y) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public void loadTiles() {
        this.tiles = MainWindow.xmlDoc.getTiles();
    }

    private void writeMapName(int zeile) {
        char mapTile = MainWindow.nameMap.map[this.xMapPosition][this.yMapPosition];
        try {
            String text = MainWindow.nameMap.nameMapTiles.get((Object)new StringBuilder().append((char)mapTile).toString()).text;
            if (text != null) {
                MainWindow.pnlText.writeText(text, zeile);
            } else {
                MainWindow.pnlText.writeText("Auf unbekanntem Gebiet", zeile);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void scrollLeft() {
        char map_char;
        if (this.renderMode == 0) {
            if (this.xMapPosition - 1 >= 0) {
                map_char = MainWindow.surfaceMap.map[this.xMapPosition - 1][this.yMapPosition];
                if (!this.onBoard) {
                    if (this.getTileBetretbar(0, map_char)) {
                        --this.xMapPosition;
                        this.paintComponent(this.getGraphics());
                        this.writeMapName(0);
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("go_w"), 1);
                        this.testBetrettipp();
                    } else if (this.xMapPosition - 1 == this.xShipPosition && this.yMapPosition == this.yShipPosition) {
                        this.xMapPosition = this.xShipPosition;
                        this.yMapPosition = this.yShipPosition;
                        this.onBoard = true;
                    }
                } else if (this.getTileSchiffbar(0, map_char)) {
                    --this.xMapPosition;
                    --this.xShipPosition;
                    this.shipRenderDirection = 3;
                    this.paintComponent(this.getGraphics());
                    this.writeMapName(0);
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("sail_w"), 1);
                } else if (this.getTileBetretbar(0, map_char)) {
                    this.onBoard = false;
                    --this.xMapPosition;
                }
            } else {
                this.xMapPosition = MainWindow.surfaceMap.width - 1;
                if (this.onBoard) {
                    this.xShipPosition = this.xMapPosition;
                }
            }
        }
        if (this.renderMode == 1) {
            if (this.xSettPosition - 1 < 0) {
                this.leaveSettlement();
                return;
            }
            map_char = MainWindow.settlements[this.aktSettlement].map[this.xSettPosition - 1][this.ySettPosition];
            if (this.getTileBetretbar(1, map_char)) {
                --this.xSettPosition;
                this.paintComponent(this.getGraphics());
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("wander_w"), 0);
            } else {
                int i = 0;
                while (i < MainWindow.settlements[this.aktSettlement].citizens.size()) {
                    Citizen cit = MainWindow.settlements[this.aktSettlement].citizens.get(i);
                    if (cit.x == this.xSettPosition - 1 && cit.y == this.ySettPosition || cit.x == this.xSettPosition - 2 && cit.y == this.ySettPosition && this.getTileDurchschaubar(1, map_char)) {
                        MainWindow.pnlText.clearTextArea();
                        MainWindow.pnlText.writeText(cit.text);
                        this.aktCitizen = i;
                        if (cit.cittexts != null && cit.cittexts.size() > 0) {
                            this.initTalk();
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.renderMode == 3) {
            --this.dungViewDirection;
            if (this.dungViewDirection < 0) {
                this.dungViewDirection = 3;
            }
            this.paintComponent(this.getGraphics());
            MainWindow.pnlText.clearTextArea();
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("turn_l"));
            if (this.light <= 0) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("its_dark"));
            }
            this.writeDungeonViewDirection();
        }
    }

    public void scrollRight() {
        char map_char;
        if (this.renderMode == 0) {
            if (this.xMapPosition + 1 < MainWindow.surfaceMap.width) {
                map_char = MainWindow.surfaceMap.map[this.xMapPosition + 1][this.yMapPosition];
                if (!this.onBoard) {
                    if (this.getTileBetretbar(0, map_char)) {
                        ++this.xMapPosition;
                        this.paintComponent(this.getGraphics());
                        this.writeMapName(0);
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("wander_e"), 1);
                        this.testBetrettipp();
                    } else if (this.xMapPosition + 1 == this.xShipPosition && this.yMapPosition == this.yShipPosition) {
                        this.xMapPosition = this.xShipPosition;
                        this.yMapPosition = this.yShipPosition;
                        this.onBoard = true;
                    }
                } else if (this.getTileSchiffbar(0, map_char)) {
                    ++this.xMapPosition;
                    ++this.xShipPosition;
                    this.shipRenderDirection = 1;
                    this.paintComponent(this.getGraphics());
                    this.writeMapName(0);
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("sail_e"), 1);
                } else if (this.getTileBetretbar(0, map_char)) {
                    this.onBoard = false;
                    ++this.xMapPosition;
                }
            } else {
                this.xMapPosition = 0;
                if (this.onBoard) {
                    this.xShipPosition = 0;
                }
            }
        }
        if (this.renderMode == 1) {
            if (this.xSettPosition + 1 > MainWindow.settlements[this.aktSettlement].mapWidth - 1) {
                this.leaveSettlement();
                return;
            }
            map_char = MainWindow.settlements[this.aktSettlement].map[this.xSettPosition + 1][this.ySettPosition];
            if (this.getTileBetretbar(1, map_char)) {
                ++this.xSettPosition;
                this.paintComponent(this.getGraphics());
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("go_e"), 0);
            } else {
                int i = 0;
                while (i < MainWindow.settlements[this.aktSettlement].citizens.size()) {
                    Citizen cit = MainWindow.settlements[this.aktSettlement].citizens.get(i);
                    if (cit.x == this.xSettPosition + 1 && cit.y == this.ySettPosition || cit.x == this.xSettPosition + 2 && cit.y == this.ySettPosition && this.getTileDurchschaubar(1, map_char)) {
                        MainWindow.pnlText.clearTextArea();
                        MainWindow.pnlText.writeText(cit.text);
                        this.aktCitizen = i;
                        if (cit.cittexts != null && cit.cittexts.size() > 0) {
                            this.initTalk();
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.renderMode == 3) {
            ++this.dungViewDirection;
            if (this.dungViewDirection > 3) {
                this.dungViewDirection = 0;
            }
            this.paintComponent(this.getGraphics());
            MainWindow.pnlText.clearTextArea();
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("turn_r"));
            if (this.light <= 0) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("its_dark"));
            }
            this.writeDungeonViewDirection();
        }
    }

    public void scrollUp() {
        char map_char;
        if (this.renderMode == 0) {
            if (this.yMapPosition - 1 >= 0) {
                map_char = MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition - 1];
                if (!this.onBoard) {
                    if (this.getTileBetretbar(0, map_char)) {
                        --this.yMapPosition;
                        this.paintComponent(this.getGraphics());
                        this.writeMapName(0);
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("wander_n"), 1);
                        this.testBetrettipp();
                    } else if (this.xMapPosition == this.xShipPosition && this.yMapPosition - 1 == this.yShipPosition) {
                        this.xMapPosition = this.xShipPosition;
                        this.yMapPosition = this.yShipPosition;
                        this.onBoard = true;
                    }
                } else if (this.getTileSchiffbar(0, map_char)) {
                    --this.yMapPosition;
                    --this.yShipPosition;
                    this.shipRenderDirection = 0;
                    this.paintComponent(this.getGraphics());
                    this.writeMapName(0);
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("sail_n"), 1);
                } else if (this.getTileBetretbar(0, map_char)) {
                    this.onBoard = false;
                    --this.yMapPosition;
                }
            } else {
                this.yMapPosition = MainWindow.surfaceMap.height - 1;
                if (this.onBoard) {
                    this.yShipPosition = this.yMapPosition;
                }
            }
        }
        if (this.renderMode == 1) {
            if (this.ySettPosition - 1 < 0) {
                this.leaveSettlement();
                return;
            }
            map_char = MainWindow.settlements[this.aktSettlement].map[this.xSettPosition][this.ySettPosition - 1];
            if (this.getTileBetretbar(1, map_char)) {
                --this.ySettPosition;
                this.paintComponent(this.getGraphics());
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("go_n"), 0);
            } else {
                int i = 0;
                while (i < MainWindow.settlements[this.aktSettlement].citizens.size()) {
                    Citizen cit = MainWindow.settlements[this.aktSettlement].citizens.get(i);
                    if (cit.x == this.xSettPosition && cit.y == this.ySettPosition - 1 || cit.x == this.xSettPosition && cit.y == this.ySettPosition - 2 && this.getTileDurchschaubar(1, map_char)) {
                        MainWindow.pnlText.clearTextArea();
                        MainWindow.pnlText.writeText(cit.text);
                        this.aktCitizen = i;
                        if (cit.cittexts != null && cit.cittexts.size() > 0) {
                            this.initTalk();
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.renderMode == 3) {
            int xs = 0;
            int ys = 0;
            if (this.dungViewDirection == 0) {
                xs = 1;
                ys = 0;
            }
            if (this.dungViewDirection == 3) {
                xs = 0;
                ys = -1;
            }
            if (this.dungViewDirection == 2) {
                xs = -1;
                ys = 0;
            }
            if (this.dungViewDirection == 1) {
                xs = 0;
                ys = 1;
            }
            if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys] != '*') {
                if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys] == '1' || MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys] == '2' || MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys] == '3' || MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys] == '4') {
                    boolean unlocked = false;
                    switch (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys]) {
                        case '1': {
                            unlocked = true;
                            break;
                        }
                        case '2': {
                            if (!(Math.random() * 100.0 > 30.0)) break;
                            unlocked = true;
                            break;
                        }
                        case '3': {
                            if (!(Math.random() * 100.0 > 60.0)) break;
                            unlocked = true;
                            break;
                        }
                        case '4': {
                            if (!(Math.random() * 100.0 > 90.0)) break;
                            unlocked = true;
                        }
                    }
                    if (this.keys > 0) {
                        --this.keys;
                        MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
                        if (unlocked) {
                            MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys] = 46;
                            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("door_unlocked"), 0);
                        } else {
                            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("key_broke"), 0);
                        }
                    } else {
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("door_locked"), 0);
                    }
                } else {
                    MainWindow.pnlText.clearTextArea();
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("go_on"));
                    if (this.light <= 0) {
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("its_dark"));
                    }
                    this.writeDungeonViewDirection();
                    this.xDungPosition += xs;
                    this.yDungPosition += ys;
                    this.paintComponent(this.getGraphics());
                }
            } else {
                if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys] == '*') {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("way_blocked"), 0);
                }
                if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys] == '4') {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("door_locked"), 0);
                }
            }
        }
    }

    public void scrollDown() {
        char map_char;
        if (this.renderMode == 0) {
            if (this.yMapPosition + 1 < MainWindow.surfaceMap.height) {
                map_char = MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition + 1];
                if (!this.onBoard) {
                    if (this.getTileBetretbar(0, map_char)) {
                        ++this.yMapPosition;
                        this.paintComponent(this.getGraphics());
                        this.writeMapName(0);
                        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("wander_s"), 1);
                        this.testBetrettipp();
                    } else if (this.xMapPosition == this.xShipPosition && this.yMapPosition + 1 == this.yShipPosition) {
                        this.xMapPosition = this.xShipPosition;
                        this.yMapPosition = this.yShipPosition;
                        this.onBoard = true;
                    }
                } else if (this.getTileSchiffbar(0, map_char)) {
                    ++this.yMapPosition;
                    ++this.yShipPosition;
                    this.shipRenderDirection = 2;
                    this.paintComponent(this.getGraphics());
                    this.writeMapName(0);
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("sail_s"), 1);
                } else if (this.getTileBetretbar(0, map_char)) {
                    this.onBoard = false;
                    ++this.yMapPosition;
                }
            } else {
                this.yMapPosition = 0;
                if (this.onBoard) {
                    this.yShipPosition = 0;
                }
            }
        }
        if (this.renderMode == 1) {
            if (this.ySettPosition + 1 > MainWindow.settlements[this.aktSettlement].mapHeight - 1) {
                this.leaveSettlement();
                return;
            }
            map_char = MainWindow.settlements[this.aktSettlement].map[this.xSettPosition][this.ySettPosition + 1];
            if (this.getTileBetretbar(1, map_char)) {
                ++this.ySettPosition;
                this.paintComponent(this.getGraphics());
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("go_s"), 0);
            } else {
                int i = 0;
                while (i < MainWindow.settlements[this.aktSettlement].citizens.size()) {
                    Citizen cit = MainWindow.settlements[this.aktSettlement].citizens.get(i);
                    if (cit.x == this.xSettPosition && cit.y == this.ySettPosition + 1 || cit.x == this.xSettPosition && cit.y == this.ySettPosition + 2 && this.getTileDurchschaubar(1, map_char)) {
                        MainWindow.pnlText.clearTextArea();
                        MainWindow.pnlText.writeText(cit.text);
                        this.aktCitizen = i;
                        if (cit.cittexts != null && cit.cittexts.size() > 0) {
                            this.initTalk();
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.renderMode == 3) {
            int xs = 0;
            int ys = 0;
            if (this.dungViewDirection == 0) {
                xs = -1;
                ys = 0;
            }
            if (this.dungViewDirection == 3) {
                xs = 0;
                ys = 1;
            }
            if (this.dungViewDirection == 2) {
                xs = 1;
                ys = 0;
            }
            if (this.dungViewDirection == 1) {
                xs = 0;
                ys = -1;
            }
            if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + xs][this.yDungPosition + ys] == '.') {
                MainWindow.pnlText.clearTextArea();
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("go_back"));
                if (this.light <= 0) {
                    MainWindow.pnlText.writeText(MainWindow.screenTexts.get("its_dark"));
                }
                this.xDungPosition += xs;
                this.yDungPosition += ys;
                this.paintComponent(this.getGraphics());
                this.writeDungeonViewDirection();
            } else {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("way_blocked"), 0);
            }
        }
    }

    private void writeDungeonViewDirection() {
        if (this.dungViewDirection == 0) {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("view_east"));
        }
        if (this.dungViewDirection == 3) {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("view_north"));
        }
        if (this.dungViewDirection == 2) {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("view_west"));
        }
        if (this.dungViewDirection == 1) {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("view_south"));
        }
    }

    public void testBetrettipp() {
        char c = MainWindow.surfaceMap.map[this.xMapPosition][this.yMapPosition];
        if (c == 's' || c == 'b' || c == 'k' || c == 'S' || c == 'h') {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("tip_space"), 2);
        }
    }

    public void climbLadder() {
        --this.aktDungLevel;
        if (this.aktDungLevel < 0) {
            this.leaveDungeon();
            return;
        }
        int[] pos = this.searchCharPosInDungeonlevel('d');
        this.xDungPosition = pos[0];
        this.yDungPosition = pos[1];
        if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + 1][this.yDungPosition] == '.') {
            ++this.xDungPosition;
            return;
        }
        if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition - 1][this.yDungPosition] == '.') {
            --this.xDungPosition;
            return;
        }
        if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition + 1] == '.') {
            ++this.yDungPosition;
            return;
        }
        if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition - 1] == '.') {
            --this.yDungPosition;
            return;
        }
    }

    public boolean descentLadder() {
        if (MainWindow.dungeons[this.aktDungeon].levels.length > this.aktDungLevel + 1) {
            ++this.aktDungLevel;
        } else {
            return false;
        }
        int[] pos = this.searchCharPosInDungeonlevel('u');
        this.xDungPosition = pos[0];
        this.yDungPosition = pos[1];
        if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition + 1][this.yDungPosition] == '.') {
            ++this.xDungPosition;
            return true;
        }
        if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition - 1][this.yDungPosition] == '.') {
            --this.xDungPosition;
            return true;
        }
        if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition + 1] == '.') {
            ++this.yDungPosition;
            return true;
        }
        if (MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition - 1] == '.') {
            --this.yDungPosition;
            return true;
        }
        return false;
    }

    private void leaveDungeon() {
        this.renderMode = 0;
        this.paintComponent(this.getGraphics());
        this.startSoundPlayer(MainWindow.sndPlayerWanderer);
        System.gc();
    }

    private void enterDungeon(int x, int y) {
        boolean entryAllowed = false;
        this.oldRenderMode = 3;
        this.aktDungeon = -1;
        this.aktDungeon = this.getDungeonByPosition(x, y);
        if (this.aktDungeon == -1) {
            MainWindow.pnlText.clearTextArea();
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("dungeon_not_pass"));
            return;
        }
        int i = 0;
        while (i < MainWindow.inventoryItems.size()) {
            Item item = MainWindow.inventoryItems.get(i);
            if (item.effect.equalsIgnoreCase("enter_dungeon") && item.param.equalsIgnoreCase(MainWindow.dungeons[this.aktDungeon].name)) {
                entryAllowed = true;
            }
            ++i;
        }
        if (!entryAllowed) {
            MainWindow.pnlText.clearTextArea();
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_dungeon_entry"));
            return;
        }
        if (this.aktDungeon != -1) {
            this.renderMode = 3;
            this.descentLadder();
            MainWindow.pnlText.clearTextArea();
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("enter_dungeon"), new String[]{MainWindow.dungeons[this.aktDungeon].name});
            if (this.light <= 0) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("its_dark"));
            }
            this.paintComponent(this.getGraphics());
            this.startSoundPlayer(MainWindow.sndPlayerDungeon);
        }
    }

    public int[] searchCharPosInDungeonlevel(char c) {
        int[] result = new int[2];
        char[][] locMap = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map;
        int x = 0;
        while (x < locMap.length) {
            int y = 0;
            while (y < locMap[0].length) {
                if (locMap[x][y] == c) {
                    result[0] = x;
                    result[1] = y;
                }
                ++y;
            }
            ++x;
        }
        return result;
    }

    public void resizeImages() {
        this.aktHeight = this.getHeight();
        this.aktWidth = this.getWidth();
        if (this.aktHeight == 0 || this.aktWidth == 0) {
            return;
        }
        this.scaleFacX = this.aktWidth / this.zoom;
        this.scaleFacY = this.aktHeight / this.zoom;
        if (this.scaleFacX == 0) {
            this.scaleFacX = 1;
        }
        if (this.scaleFacY == 0) {
            this.scaleFacY = 1;
        }
        int i = 0;
        while (i < this.imgOrg.length) {
            this.img[i] = null;
            if (this.tiles[i].type < 7) {
                this.img[i] = this.imgOrg[i].getScaledInstance(this.scaleFacX, this.scaleFacY, 2);
            } else if (this.tiles[i].type == 7 || this.tiles[i].type == 20) {
                this.img[i] = this.imgOrg[i].getScaledInstance(this.aktWidth, this.aktHeight, 2);
            } else if (this.tiles[i].type == 21) {
                this.img[i] = this.imgOrg[i].getScaledInstance(this.aktWidth / 2 == 0 ? 1 : this.aktWidth / 2, this.aktHeight / 2 == 0 ? 1 : this.aktHeight / 2, 2);
            } else if (this.tiles[i].type == 22) {
                this.img[i] = this.imgOrg[i].getScaledInstance(this.aktWidth / 4 == 0 ? 1 : this.aktWidth / 4, this.aktHeight / 4 == 0 ? 1 : this.aktHeight / 4, 2);
            } else if (this.tiles[i].type == 23) {
                this.img[i] = this.imgOrg[i].getScaledInstance(this.aktWidth / 8 == 0 ? 1 : this.aktWidth / 8, this.aktHeight / 8 == 0 ? 1 : this.aktHeight / 8, 2);
            }
            ++i;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int aktHeight = this.getHeight();
        int aktWidth = this.getWidth();
        this.scaleFacX = aktWidth / this.zoom;
        this.scaleFacY = aktHeight / this.zoom;
        if (this.renderMode == 0) {
            this.paintWilderness(g);
        }
        if (this.renderMode == 1) {
            this.paintSettlement(g);
        }
        if (this.renderMode == 3) {
            this.paintDungeon(g);
        }
        if (this.renderMode == 2) {
            this.paintTactics(g);
        }
    }

    public void loadImages() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.img = new Image[this.tiles.length];
        this.imgOrg = new Image[this.tiles.length];
        int i = 0;
        while (i < this.tiles.length) {
            String resLink = "/" + this.tiles[i].imgFileName;
            System.out.println(resLink);
            URL url = null;
            if (MainWindow.isInternetVersion) {
                try {
                    url = new URL(String.valueOf(MainWindow.internetBase) + resLink);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                url = this.getClass().getResource(resLink);
            }
            this.imgOrg[i] = tk.getImage(url);
            ++i;
        }
        MediaTracker mt = new MediaTracker(this);
        int i2 = 0;
        while (i2 < this.imgOrg.length) {
            mt.addImage(this.imgOrg[i2], 0);
            this.img[i2] = this.tiles[i2].type < 7 ? this.imgOrg[i2].getScaledInstance(this.scaleFacX, this.scaleFacY, 2) : this.imgOrg[i2].getScaledInstance(128, 128, 2);
            ++i2;
        }
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private char fillRenderMap(int x, int y) {
        char[][] levelMap = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map;
        char result = '.';
        try {
            result = levelMap[x][y];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public void paintDungeon(Graphics g) {
        if (this.light <= 0) {
            return;
        }
        this.setBackground(new Color(0.2f, 0.2f, 0.2f));
        char[][] renderMap = new char[4][3];
        int x = this.xDungPosition;
        int y = this.yDungPosition;
        if (this.dungViewDirection == 0) {
            renderMap[0][0] = this.fillRenderMap(x, y - 1);
            renderMap[0][1] = this.fillRenderMap(x, y);
            renderMap[0][2] = this.fillRenderMap(x, y + 1);
            renderMap[1][0] = this.fillRenderMap(x + 1, y - 1);
            renderMap[1][1] = this.fillRenderMap(x + 1, y);
            renderMap[1][2] = this.fillRenderMap(x + 1, y + 1);
            renderMap[2][0] = this.fillRenderMap(x + 2, y - 1);
            renderMap[2][1] = this.fillRenderMap(x + 2, y);
            renderMap[2][2] = this.fillRenderMap(x + 2, y + 1);
            renderMap[3][0] = this.fillRenderMap(x + 3, y - 1);
            renderMap[3][1] = this.fillRenderMap(x + 3, y);
            renderMap[3][2] = this.fillRenderMap(x + 3, y + 1);
        }
        if (this.dungViewDirection == 1) {
            renderMap[0][0] = this.fillRenderMap(x + 1, y);
            renderMap[0][1] = this.fillRenderMap(x, y);
            renderMap[0][2] = this.fillRenderMap(x - 1, y);
            renderMap[1][0] = this.fillRenderMap(x + 1, y + 1);
            renderMap[1][1] = this.fillRenderMap(x, y + 1);
            renderMap[1][2] = this.fillRenderMap(x - 1, y + 1);
            renderMap[2][0] = this.fillRenderMap(x + 1, y + 2);
            renderMap[2][1] = this.fillRenderMap(x, y + 2);
            renderMap[2][2] = this.fillRenderMap(x - 1, y + 2);
            renderMap[3][0] = this.fillRenderMap(x + 1, y + 3);
            renderMap[3][1] = this.fillRenderMap(x, y + 3);
            renderMap[3][2] = this.fillRenderMap(x - 1, y + 3);
        }
        if (this.dungViewDirection == 2) {
            renderMap[0][0] = this.fillRenderMap(x, y + 1);
            renderMap[0][1] = this.fillRenderMap(x, y);
            renderMap[0][2] = this.fillRenderMap(x, y - 1);
            renderMap[1][0] = this.fillRenderMap(x - 1, y + 1);
            renderMap[1][1] = this.fillRenderMap(x - 1, y);
            renderMap[1][2] = this.fillRenderMap(x - 1, y - 1);
            renderMap[2][0] = this.fillRenderMap(x - 2, y + 1);
            renderMap[2][1] = this.fillRenderMap(x - 2, y);
            renderMap[2][2] = this.fillRenderMap(x - 2, y - 1);
            renderMap[3][0] = this.fillRenderMap(x - 3, y + 1);
            renderMap[3][1] = this.fillRenderMap(x - 3, y);
            renderMap[3][2] = this.fillRenderMap(x - 3, y - 1);
        }
        if (this.dungViewDirection == 3) {
            renderMap[0][0] = this.fillRenderMap(x - 1, y);
            renderMap[0][1] = this.fillRenderMap(x, y);
            renderMap[0][2] = this.fillRenderMap(x + 1, y);
            renderMap[1][0] = this.fillRenderMap(x - 1, y - 1);
            renderMap[1][1] = this.fillRenderMap(x, y - 1);
            renderMap[1][2] = this.fillRenderMap(x + 1, y - 1);
            renderMap[2][0] = this.fillRenderMap(x - 1, y - 2);
            renderMap[2][1] = this.fillRenderMap(x, y - 2);
            renderMap[2][2] = this.fillRenderMap(x + 1, y - 2);
            renderMap[3][0] = this.fillRenderMap(x - 1, y - 3);
            renderMap[3][1] = this.fillRenderMap(x, y - 3);
            renderMap[3][2] = this.fillRenderMap(x + 1, y - 3);
        }
        if (renderMap[1][1] == '*') {
            renderMap[2][0] = 46;
            renderMap[2][1] = 46;
            renderMap[2][2] = 46;
            renderMap[3][0] = 46;
            renderMap[3][1] = 46;
            renderMap[3][2] = 46;
        }
        if (renderMap[2][1] == '*') {
            renderMap[3][0] = 46;
            renderMap[3][1] = 46;
            renderMap[3][2] = 46;
        }
        if (renderMap[3][0] == '*') {
            this.drawTile(g, "TILE_DNG_L_4", 0, 0);
        }
        if (renderMap[3][0] == '1' || renderMap[3][0] == '2' || renderMap[3][0] == '3' || renderMap[3][0] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_L_4", 0, 0);
        }
        if (renderMap[3][2] == '*') {
            this.drawTile(g, "TILE_DNG_R_4", 0, 0);
        }
        if (renderMap[3][2] == '1' || renderMap[3][2] == '2' || renderMap[3][2] == '3' || renderMap[3][2] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_R_4", 0, 0);
        }
        if (renderMap[3][1] == '*') {
            this.drawTile(g, "TILE_DNG_M_4", 0, 0);
        }
        if (renderMap[3][1] == '1' || renderMap[3][1] == '2' || renderMap[3][1] == '3' || renderMap[3][1] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_M_4", 0, 0);
        }
        if (renderMap[3][1] == 'u') {
            this.drawTile(g, "LEITER_OBEN4", 0.4375f, 0.4375f);
        }
        if (renderMap[3][1] == 'd') {
            this.drawTile(g, "LEITER_UNTEN4", 0.4375f, 0.4375f);
        }
        if (renderMap[3][1] == 'A' || renderMap[3][1] == 'B' || renderMap[3][1] == 'C' || renderMap[3][1] == 'D') {
            this.drawTile(g, "KISTE4", 0.4375f, 0.4375f);
        }
        if (renderMap[3][1] == 'h' || renderMap[3][1] == 'c' || renderMap[3][1] == 'p' || renderMap[3][1] == 'm') {
            this.drawTile(g, "FOUNTAIN4", 0.4375f, 0.4375f);
        }
        if (renderMap[3][1] == 'a') {
            this.drawTile(g, "ALTAR4", 0.4375f, 0.4375f);
        }
        if (renderMap[2][0] == '*') {
            this.drawTile(g, "TILE_DNG_L_3", 0, 0);
        }
        if (renderMap[2][0] == '1' || renderMap[2][0] == '2' || renderMap[2][0] == '3' || renderMap[2][0] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_L_3", 0, 0);
        }
        if (renderMap[2][2] == '*') {
            this.drawTile(g, "TILE_DNG_R_3", 0, 0);
        }
        if (renderMap[2][2] == '1' || renderMap[2][2] == '2' || renderMap[2][2] == '3' || renderMap[2][2] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_R_3", 0, 0);
        }
        if (renderMap[2][1] == '*') {
            this.drawTile(g, "TILE_DNG_M_3", 0, 0);
        }
        if (renderMap[2][1] == '1' || renderMap[2][1] == '2' || renderMap[2][1] == '3' || renderMap[2][1] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_M_3", 0, 0);
        }
        if (renderMap[2][1] == 'u') {
            this.drawTile(g, "LEITER_OBEN3", 0.375f, 0.375f);
        }
        if (renderMap[2][1] == 'd') {
            this.drawTile(g, "LEITER_UNTEN3", 0.375f, 0.375f);
        }
        if (renderMap[2][1] == 'A' || renderMap[2][1] == 'B' || renderMap[2][1] == 'C' || renderMap[2][1] == 'D') {
            this.drawTile(g, "KISTE3", 0.375f, 0.375f);
        }
        if (renderMap[2][1] == 'h' || renderMap[2][1] == 'c' || renderMap[2][1] == 'p' || renderMap[2][1] == 'm') {
            this.drawTile(g, "FOUNTAIN3", 0.375f, 0.375f);
        }
        if (renderMap[2][1] == 'a') {
            this.drawTile(g, "ALTAR3", 0.375f, 0.375f);
        }
        if (renderMap[1][0] == '*') {
            this.drawTile(g, "TILE_DNG_L_2", 0, 0);
        }
        if (renderMap[1][0] == '1' || renderMap[1][0] == '2' || renderMap[1][0] == '3' || renderMap[1][0] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_L_2", 0, 0);
        }
        if (renderMap[1][2] == '*') {
            this.drawTile(g, "TILE_DNG_R_2", 0, 0);
        }
        if (renderMap[1][2] == '1' || renderMap[1][2] == '2' || renderMap[1][2] == '3' || renderMap[1][2] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_R_2", 0, 0);
        }
        if (renderMap[1][1] == '*') {
            this.drawTile(g, "TILE_DNG_M_2", 0, 0);
        }
        if (renderMap[1][1] == '1' || renderMap[1][1] == '2' || renderMap[1][1] == '3' || renderMap[1][1] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_M_2", 0, 0);
        }
        if (renderMap[1][1] == 'u') {
            this.drawTile(g, "LEITER_OBEN2", 0.25f, 0.25f);
        }
        if (renderMap[1][1] == 'd') {
            this.drawTile(g, "LEITER_UNTEN2", 0.25f, 0.25f);
        }
        if (renderMap[1][1] == 'A' || renderMap[1][1] == 'B' || renderMap[1][1] == 'C' || renderMap[1][1] == 'D') {
            this.drawTile(g, "KISTE2", 0.25f, 0.25f);
        }
        if (renderMap[1][1] == 'h' || renderMap[1][1] == 'c' || renderMap[1][1] == 'p' || renderMap[1][1] == 'm') {
            this.drawTile(g, "FOUNTAIN2", 0.25f, 0.25f);
        }
        if (renderMap[1][1] == 'a') {
            this.drawTile(g, "ALTAR2", 0.25f, 0.25f);
        }
        if (renderMap[0][0] == '*') {
            this.drawTile(g, "TILE_DNG_L_1", 0, 0);
        }
        if (renderMap[0][0] == '1' || renderMap[0][0] == '2' || renderMap[0][0] == '3' || renderMap[0][0] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_L_1", 0, 0);
        }
        if (renderMap[0][2] == '*') {
            this.drawTile(g, "TILE_DNG_R_1", 0, 0);
        }
        if (renderMap[0][2] == '1' || renderMap[0][2] == '2' || renderMap[0][2] == '3' || renderMap[0][2] == '4') {
            this.drawTile(g, "TILE_DNGDOOR_R_1", 0, 0);
        }
        if (renderMap[0][1] == 'u') {
            this.drawTile(g, "LEITER_OBEN1", 0, 0);
        }
        if (renderMap[0][1] == 'd') {
            this.drawTile(g, "LEITER_UNTEN1", 0, 0);
        }
        if (renderMap[0][1] == 'A' || renderMap[0][1] == 'B' || renderMap[0][1] == 'C' || renderMap[0][1] == 'D') {
            this.drawTile(g, "KISTE1", 0, 0);
        }
        if (renderMap[0][1] == 'h' || renderMap[0][1] == 'c' || renderMap[0][1] == 'p' || renderMap[0][1] == 'm') {
            this.drawTile(g, "FOUNTAIN1", 0, 0);
        }
        if (renderMap[0][1] == 'a') {
            this.drawTile(g, "ALTAR1", 0, 0);
        }
    }

    public void paintSettlement(Graphics g) {
        this.setBackground(new Color(0.0f, 0.0f, 0.0f));
        int y = 0;
        while (y < this.zoom) {
            int x = 0;
            while (x < this.zoom) {
                try {
                    int absPosX = x + this.xSettPosition - this.zoom / 2;
                    int absPosY = y + this.ySettPosition - this.zoom / 2;
                    this.drawTile(g, 1, MainWindow.settlements[this.aktSettlement].map[absPosX][absPosY], x, y);
                }
                catch (IndexOutOfBoundsException e) {
                    this.drawTile(g, 1, MainWindow.settlements[this.aktSettlement].margintile, x, y);
                }
                ++x;
            }
            ++y;
        }
        int i = 0;
        while (i < MainWindow.settlements[this.aktSettlement].citizens.size()) {
            Citizen cit = MainWindow.settlements[this.aktSettlement].citizens.get(i);
            this.drawTile(g, cit.tileName, cit.x - this.xSettPosition + this.zoom / 2, cit.y - this.ySettPosition + this.zoom / 2);
            ++i;
        }
        this.drawTile(g, "TILE_ADELIGER", this.zoom / 2, this.zoom / 2);
    }

    public void paintTactics(Graphics g) {
        this.setBackground(new Color(0.0f, 0.0f, 0.0f));
        TacticScreen tScreen = null;
        tScreen = this.oldRenderMode == 3 ? MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].tacticscreens[this.aktTacticScreen] : MainWindow.tacticScreens[this.aktTacticScreen];
        int y = 0;
        while (y < tScreen.mapHeight) {
            int x = 0;
            while (x < tScreen.mapWidth) {
                try {
                    this.drawTile(g, 1, tScreen.map[x][y], x, y);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++x;
            }
            ++y;
        }
        int i = 0;
        while (i < 4) {
            if (MainWindow.characters[i].aktHp > 0) {
                this.drawTile(g, MainWindow.professions[MainWindow.characters[i].profession].renderTile, MainWindow.characters[i].xTactic, MainWindow.characters[i].yTactic);
            }
            ++i;
        }
        this.drawTile(g, "TILE_CURSOR", MainWindow.characters[this.selectedCharacter].xTactic, MainWindow.characters[this.selectedCharacter].yTactic);
        i = 0;
        while (i < 12) {
            if (MainWindow.tacticMonsters[i] != null) {
                this.drawTile(g, MainWindow.tacticMonsters[i].type.tile, MainWindow.tacticMonsters[i].x, MainWindow.tacticMonsters[i].y);
            }
            ++i;
        }
        if (this.renderHit) {
            this.drawTile(g, "TILE_HIT", this.xHit, this.yHit);
        }
        if (this.renderEnemyHit) {
            this.drawTile(g, "TILE_HIT", this.xEnemyHit, this.yEnemyHit);
        }
    }

    public void paintWilderness(Graphics g) {
        int x;
        char mapTile;
        int y;
        int sight = 6;
        this.setBackground(new Color(0.0f, 0.0f, 0.0f));
        int x2 = -1;
        while (x2 < 2) {
            y = -1;
            while (y < 2) {
                this.drawTileWilderness(g, 0, x2 + this.zoom / 2, y + this.zoom / 2);
                ++y;
            }
            ++x2;
        }
        x2 = -1;
        while (x2 < 2) {
            y = -1;
            mapTile = this.getSurfaceMapTile(this.xMapPosition + x2, this.yMapPosition + y);
            while (y > -sight && this.getTileDurchschaubar(0, mapTile)) {
                this.drawTileWilderness(g, 0, x2 + this.zoom / 2, --y + this.zoom / 2);
                mapTile = this.getSurfaceMapTile(this.xMapPosition + x2, this.yMapPosition + y);
            }
            ++x2;
        }
        x2 = -1;
        while (x2 < 2) {
            y = 1;
            mapTile = this.getSurfaceMapTile(this.xMapPosition + x2, this.yMapPosition + y);
            while (y < sight && this.getTileDurchschaubar(0, mapTile)) {
                this.drawTileWilderness(g, 0, x2 + this.zoom / 2, ++y + this.zoom / 2);
                mapTile = this.getSurfaceMapTile(this.xMapPosition + x2, this.yMapPosition + y);
            }
            ++x2;
        }
        int y2 = -1;
        while (y2 < 2) {
            x = 1;
            mapTile = this.getSurfaceMapTile(this.xMapPosition + x, this.yMapPosition + y2);
            while (x < sight && this.getTileDurchschaubar(0, mapTile)) {
                this.drawTileWilderness(g, 0, ++x + this.zoom / 2, y2 + this.zoom / 2);
                mapTile = this.getSurfaceMapTile(this.xMapPosition + x, this.yMapPosition + y2);
            }
            ++y2;
        }
        y2 = -1;
        while (y2 < 2) {
            x = -1;
            mapTile = this.getSurfaceMapTile(this.xMapPosition + x, this.yMapPosition + y2);
            while (x > -sight && this.getTileDurchschaubar(0, mapTile)) {
                this.drawTileWilderness(g, 0, --x + this.zoom / 2, y2 + this.zoom / 2);
                mapTile = this.getSurfaceMapTile(this.xMapPosition + x, this.yMapPosition + y2);
            }
            ++y2;
        }
        if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 1, this.yMapPosition - 1))) {
            this.drawTileWilderness(g, 0, -2 + this.zoom / 2, -2 + this.zoom / 2);
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 2, this.yMapPosition - 1))) {
                this.drawTileWilderness(g, 0, -3 + this.zoom / 2, -2 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 3, this.yMapPosition - 1))) {
                    this.drawTileWilderness(g, 0, -4 + this.zoom / 2, -2 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 4, this.yMapPosition - 2))) {
                        this.drawTileWilderness(g, 0, -5 + this.zoom / 2, -3 + this.zoom / 2);
                    }
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 4, this.yMapPosition - 1))) {
                        this.drawTileWilderness(g, 0, -5 + this.zoom / 2, -2 + this.zoom / 2);
                        if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 5, this.yMapPosition - 1))) {
                            this.drawTileWilderness(g, 0, -6 + this.zoom / 2, -2 + this.zoom / 2);
                        }
                    }
                }
            }
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 2, this.yMapPosition - 2))) {
                this.drawTileWilderness(g, 0, -3 + this.zoom / 2, -3 + this.zoom / 2);
                this.drawTileWilderness(g, 0, -2 + this.zoom / 2, -3 + this.zoom / 2);
                this.drawTileWilderness(g, 0, -3 + this.zoom / 2, -2 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 3, this.yMapPosition - 3))) {
                    this.drawTileWilderness(g, 0, -3 + this.zoom / 2, -4 + this.zoom / 2);
                    this.drawTileWilderness(g, 0, -4 + this.zoom / 2, -3 + this.zoom / 2);
                    this.drawTileWilderness(g, 0, -4 + this.zoom / 2, -4 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 4, this.yMapPosition - 4))) {
                        this.drawTileWilderness(g, 0, -5 + this.zoom / 2, -4 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, -4 + this.zoom / 2, -5 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, -5 + this.zoom / 2, -5 + this.zoom / 2);
                    }
                }
            }
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 1, this.yMapPosition - 2)) && this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 1, this.yMapPosition - 3))) {
                this.drawTileWilderness(g, 0, -2 + this.zoom / 2, -4 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 2, this.yMapPosition - 4))) {
                    this.drawTileWilderness(g, 0, -2 + this.zoom / 2, -5 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 2, this.yMapPosition - 5))) {
                        this.drawTileWilderness(g, 0, -2 + this.zoom / 2, -6 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, -3 + this.zoom / 2, -5 + this.zoom / 2);
                    }
                }
            }
        }
        if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 1, this.yMapPosition - 1))) {
            this.drawTileWilderness(g, 0, 2 + this.zoom / 2, -2 + this.zoom / 2);
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 2, this.yMapPosition - 1))) {
                this.drawTileWilderness(g, 0, 3 + this.zoom / 2, -2 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 3, this.yMapPosition - 1))) {
                    this.drawTileWilderness(g, 0, 4 + this.zoom / 2, -2 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 4, this.yMapPosition - 2))) {
                        this.drawTileWilderness(g, 0, 5 + this.zoom / 2, -3 + this.zoom / 2);
                    }
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 4, this.yMapPosition - 1))) {
                        this.drawTileWilderness(g, 0, 5 + this.zoom / 2, -2 + this.zoom / 2);
                        if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 5, this.yMapPosition - 1))) {
                            this.drawTileWilderness(g, 0, 6 + this.zoom / 2, -2 + this.zoom / 2);
                        }
                    }
                }
            }
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 2, this.yMapPosition - 2))) {
                this.drawTileWilderness(g, 0, 3 + this.zoom / 2, -3 + this.zoom / 2);
                this.drawTileWilderness(g, 0, 2 + this.zoom / 2, -3 + this.zoom / 2);
                this.drawTileWilderness(g, 0, 3 + this.zoom / 2, -2 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 3, this.yMapPosition - 3))) {
                    this.drawTileWilderness(g, 0, 3 + this.zoom / 2, -4 + this.zoom / 2);
                    this.drawTileWilderness(g, 0, 4 + this.zoom / 2, -3 + this.zoom / 2);
                    this.drawTileWilderness(g, 0, 4 + this.zoom / 2, -4 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 4, this.yMapPosition - 4))) {
                        this.drawTileWilderness(g, 0, 5 + this.zoom / 2, -4 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, 4 + this.zoom / 2, -5 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, 5 + this.zoom / 2, -5 + this.zoom / 2);
                    }
                }
            }
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 1, this.yMapPosition - 2)) && this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 1, this.yMapPosition - 3))) {
                this.drawTileWilderness(g, 0, 2 + this.zoom / 2, -4 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 2, this.yMapPosition - 4))) {
                    this.drawTileWilderness(g, 0, 2 + this.zoom / 2, -5 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 2, this.yMapPosition - 5))) {
                        this.drawTileWilderness(g, 0, 2 + this.zoom / 2, -6 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, 3 + this.zoom / 2, -5 + this.zoom / 2);
                    }
                }
            }
        }
        if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 1, this.yMapPosition + 1))) {
            this.drawTileWilderness(g, 0, 2 + this.zoom / 2, 2 + this.zoom / 2);
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 2, this.yMapPosition + 1))) {
                this.drawTileWilderness(g, 0, 3 + this.zoom / 2, 2 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 3, this.yMapPosition + 1))) {
                    this.drawTileWilderness(g, 0, 4 + this.zoom / 2, 2 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 4, this.yMapPosition + 2))) {
                        this.drawTileWilderness(g, 0, 5 + this.zoom / 2, 3 + this.zoom / 2);
                    }
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 4, this.yMapPosition + 1))) {
                        this.drawTileWilderness(g, 0, 5 + this.zoom / 2, 2 + this.zoom / 2);
                        if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 5, this.yMapPosition + 1))) {
                            this.drawTileWilderness(g, 0, 6 + this.zoom / 2, 2 + this.zoom / 2);
                        }
                    }
                }
            }
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 2, this.yMapPosition + 2))) {
                this.drawTileWilderness(g, 0, 3 + this.zoom / 2, 3 + this.zoom / 2);
                this.drawTileWilderness(g, 0, 2 + this.zoom / 2, 3 + this.zoom / 2);
                this.drawTileWilderness(g, 0, 3 + this.zoom / 2, 2 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 3, this.yMapPosition + 3))) {
                    this.drawTileWilderness(g, 0, 3 + this.zoom / 2, 4 + this.zoom / 2);
                    this.drawTileWilderness(g, 0, 4 + this.zoom / 2, 3 + this.zoom / 2);
                    this.drawTileWilderness(g, 0, 4 + this.zoom / 2, 4 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 4, this.yMapPosition + 4))) {
                        this.drawTileWilderness(g, 0, 5 + this.zoom / 2, 4 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, 4 + this.zoom / 2, 5 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, 5 + this.zoom / 2, 5 + this.zoom / 2);
                    }
                }
            }
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 1, this.yMapPosition + 2)) && this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 1, this.yMapPosition + 3))) {
                this.drawTileWilderness(g, 0, 2 + this.zoom / 2, 4 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 2, this.yMapPosition + 4))) {
                    this.drawTileWilderness(g, 0, 2 + this.zoom / 2, 5 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition + 2, this.yMapPosition + 5))) {
                        this.drawTileWilderness(g, 0, 2 + this.zoom / 2, 6 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, 3 + this.zoom / 2, 5 + this.zoom / 2);
                    }
                }
            }
        }
        if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 1, this.yMapPosition + 1))) {
            this.drawTileWilderness(g, 0, -2 + this.zoom / 2, 2 + this.zoom / 2);
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 2, this.yMapPosition + 1))) {
                this.drawTileWilderness(g, 0, -3 + this.zoom / 2, 2 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 3, this.yMapPosition + 1))) {
                    this.drawTileWilderness(g, 0, -4 + this.zoom / 2, 2 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 4, this.yMapPosition + 2))) {
                        this.drawTileWilderness(g, 0, -5 + this.zoom / 2, 3 + this.zoom / 2);
                    }
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 4, this.yMapPosition + 1))) {
                        this.drawTileWilderness(g, 0, -5 + this.zoom / 2, 2 + this.zoom / 2);
                        if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 5, this.yMapPosition + 1))) {
                            this.drawTileWilderness(g, 0, -6 + this.zoom / 2, 2 + this.zoom / 2);
                        }
                    }
                }
            }
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 2, this.yMapPosition + 2))) {
                this.drawTileWilderness(g, 0, -3 + this.zoom / 2, 3 + this.zoom / 2);
                this.drawTileWilderness(g, 0, -2 + this.zoom / 2, 3 + this.zoom / 2);
                this.drawTileWilderness(g, 0, -3 + this.zoom / 2, 2 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 3, this.yMapPosition + 3))) {
                    this.drawTileWilderness(g, 0, -3 + this.zoom / 2, 4 + this.zoom / 2);
                    this.drawTileWilderness(g, 0, -4 + this.zoom / 2, 3 + this.zoom / 2);
                    this.drawTileWilderness(g, 0, -4 + this.zoom / 2, 4 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 4, this.yMapPosition + 4))) {
                        this.drawTileWilderness(g, 0, -5 + this.zoom / 2, 4 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, -4 + this.zoom / 2, 5 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, -5 + this.zoom / 2, 5 + this.zoom / 2);
                    }
                }
            }
            if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 1, this.yMapPosition + 2)) && this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 1, this.yMapPosition + 3))) {
                this.drawTileWilderness(g, 0, -2 + this.zoom / 2, 4 + this.zoom / 2);
                if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 2, this.yMapPosition + 4))) {
                    this.drawTileWilderness(g, 0, -2 + this.zoom / 2, 5 + this.zoom / 2);
                    if (this.getTileDurchschaubar(0, this.getSurfaceMapTile(this.xMapPosition - 2, this.yMapPosition + 5))) {
                        this.drawTileWilderness(g, 0, -2 + this.zoom / 2, 6 + this.zoom / 2);
                        this.drawTileWilderness(g, 0, -3 + this.zoom / 2, 5 + this.zoom / 2);
                    }
                }
            }
        }
        if (!this.onBoard) {
            this.drawTile(g, "TILE_ADELIGER", this.zoom / 2, this.zoom / 2);
        }
    }

    private char getSurfaceMapTile(int x, int y) {
        char result = '~';
        try {
            if (x >= MainWindow.surfaceMap.width) {
                x -= MainWindow.surfaceMap.width;
            }
            if (x < 0) {
                x += MainWindow.surfaceMap.width;
            }
            if (y >= MainWindow.surfaceMap.height) {
                y -= MainWindow.surfaceMap.height;
            }
            if (y < 0) {
                y += MainWindow.surfaceMap.height;
            }
            result = MainWindow.surfaceMap.map[x][y];
        }
        catch (IndexOutOfBoundsException e) {
            result = '~';
        }
        return result;
    }

    private void drawTileWilderness(Graphics g, int type, int xScreenPos, int yScreenPos) {
        this.drawTile(g, 0, this.getSurfaceMapTile(xScreenPos + this.xMapPosition - this.zoom / 2, yScreenPos + this.yMapPosition - this.zoom / 2), xScreenPos, yScreenPos);
        if (this.xShipPosition - this.xMapPosition == xScreenPos - this.zoom / 2 && this.yShipPosition - this.yMapPosition == yScreenPos - this.zoom / 2) {
            String tileStr = "TILE_SCHIFF_O";
            if (this.shipRenderDirection == 1) {
                tileStr = "TILE_SCHIFF_R";
            }
            if (this.shipRenderDirection == 2) {
                tileStr = "TILE_SCHIFF_U";
            }
            if (this.shipRenderDirection == 3) {
                tileStr = "TILE_SCHIFF_L";
            }
            this.drawTile(g, tileStr, xScreenPos, yScreenPos);
        }
        int i = 0;
        while (i < MainWindow.surfaceMonsters.length) {
            Monster surfMonst = MainWindow.surfaceMonsters[i];
            if (surfMonst != null && surfMonst.x - this.xMapPosition == xScreenPos - this.zoom / 2 && surfMonst.y - this.yMapPosition == yScreenPos - this.zoom / 2) {
                this.drawTile(g, surfMonst.type.tile, xScreenPos, yScreenPos);
            }
            ++i;
        }
    }

    private boolean getTileBetretbar(int tile_type, char map_char) {
        boolean result = false;
        int i = 0;
        while (i < this.tiles.length) {
            if (this.tiles[i].map_char == map_char && this.tiles[i].type == tile_type) {
                result = this.tiles[i].betretbar.compareToIgnoreCase("true") == 0;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean getTileSchiffbar(int tile_type, char map_char) {
        boolean result = false;
        int i = 0;
        while (i < this.tiles.length) {
            if (this.tiles[i].map_char == map_char && this.tiles[i].type == tile_type) {
                result = this.tiles[i].schiffbar.compareToIgnoreCase("true") == 0;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean getTileDurchschaubar(int tile_type, char map_char) {
        boolean result = false;
        int i = 0;
        while (i < this.tiles.length) {
            if (this.tiles[i].map_char == map_char && this.tiles[i].type == tile_type) {
                result = this.tiles[i].durchschaubar.compareToIgnoreCase("true") == 0;
                break;
            }
            ++i;
        }
        return result;
    }

    private void drawTile(Graphics g, int tile_type, char map_char, int x, int y) {
        int tileNr = -1;
        int i = 0;
        while (i < this.tiles.length) {
            if (this.tiles[i].map_char == map_char && this.tiles[i].type == tile_type) {
                tileNr = i;
                break;
            }
            ++i;
        }
        if (tileNr != -1) {
            g.drawImage(this.img[tileNr], x * this.scaleFacX, y * this.scaleFacY, this);
        }
    }

    private void drawTile(Graphics g, String tileName, int x, int y) {
        int tileNr = -1;
        int i = 0;
        while (i < this.tiles.length) {
            if (this.tiles[i].name.compareTo(tileName) == 0) {
                tileNr = i;
                break;
            }
            ++i;
        }
        if (tileNr != -1) {
            if (this.tiles[tileNr].type < 7) {
                g.drawImage(this.img[tileNr], x * this.scaleFacX, y * this.scaleFacY, this);
            } else {
                g.drawImage(this.img[tileNr], 0, 0, this);
            }
        }
    }

    private void drawTile(Graphics g, String tileName, float x, float y) {
        int tileNr = -1;
        int i = 0;
        while (i < this.tiles.length) {
            if (this.tiles[i].name.compareTo(tileName) == 0) {
                tileNr = i;
                break;
            }
            ++i;
        }
        if (tileNr != -1) {
            g.drawImage(this.img[tileNr], (int)((float)this.aktWidth * x), (int)((float)this.aktHeight * y), this);
        }
    }

    public Tile getTileByName(String tileName) {
        int tileNr = -1;
        int i = 0;
        while (i < this.tiles.length) {
            if (this.tiles[i].name.compareTo(tileName) == 0) {
                tileNr = i;
                break;
            }
            ++i;
        }
        return this.tiles[tileNr];
    }

    public void startSoundPlayer(SoundPlayer sndPlayer) {
        this.aktSoundPlayer.stop();
        this.aktSoundPlayer = sndPlayer;
        this.aktSoundPlayer.reset();
        this.aktSoundPlayer.play();
    }

    public void lightTorch() {
        MainWindow.pnlText.clearTextArea();
        if (this.torches > 0) {
            if (this.light > 0) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("torch_already_lighted"));
            } else if (this.renderMode != 3) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("torch_only_in_dung"));
            } else {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("torch_lighted"));
                --this.torches;
                this.light = MainWindow.GAME_PARAM_TORCH_BURNS_FOR_X_MOVES;
                MainWindow.pnlText.updateGoods(this.gold, this.food, this.keys, this.torches);
            }
        } else {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("no_torch_left"));
        }
    }

    public void searchItem() {
        Item item;
        int i;
        ArrayList<Item> alItems;
        MainWindow.pnlText.clearTextArea();
        if (this.renderMode == 3) {
            char mapTile = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].map[this.xDungPosition][this.yDungPosition];
            if (mapTile == 'h') {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("fountain_heal"));
                this.healAll();
                MainWindow.pnlText.updateCharacters();
                return;
            }
            if (mapTile == 'c') {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("fountain_cure"));
                this.cureAll();
                MainWindow.pnlText.updateCharacters();
                return;
            }
            if (mapTile == 'p') {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("fountain_poison"));
                this.poisonAll();
                MainWindow.pnlText.updateCharacters();
                return;
            }
            if (mapTile == 'm') {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("fountain_magic"));
                this.remagicAll();
                MainWindow.pnlText.updateCharacters();
                return;
            }
        }
        MainWindow.pnlText.writeText(MainWindow.screenTexts.get("search_for_items"));
        Item foundItem = null;
        if (this.renderMode == 0 && (alItems = MainWindow.surfaceMap.items) != null) {
            i = 0;
            while (i < alItems.size()) {
                item = alItems.get(i);
                if (item.x == this.xMapPosition && item.y == this.yMapPosition) {
                    foundItem = item;
                }
                ++i;
            }
        }
        if (this.renderMode == 1 && (alItems = MainWindow.settlements[this.aktSettlement].items) != null) {
            i = 0;
            while (i < alItems.size()) {
                item = alItems.get(i);
                if (item.x == this.xSettPosition && item.y == this.ySettPosition) {
                    foundItem = item;
                }
                ++i;
            }
        }
        if (this.renderMode == 3 && (alItems = MainWindow.dungeons[this.aktDungeon].levels[this.aktDungLevel].items) != null) {
            i = 0;
            while (i < alItems.size()) {
                item = alItems.get(i);
                if (item.x == this.xDungPosition && item.y == this.yDungPosition) {
                    foundItem = item;
                }
                ++i;
            }
        }
        boolean itemInInventory = false;
        i = 0;
        while (i < MainWindow.inventoryItems.size() && foundItem != null) {
            Item inventItem = MainWindow.inventoryItems.get(i);
            if (foundItem.name.equals(inventItem.name)) {
                itemInInventory = true;
            }
            ++i;
        }
        if (foundItem != null) {
            if (!itemInInventory) {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("found_item"));
                MainWindow.pnlText.writeText(foundItem.name);
                MainWindow.inventoryItems.add(foundItem);
            } else {
                MainWindow.pnlText.writeText(MainWindow.screenTexts.get("item_was_found"));
            }
        } else {
            MainWindow.pnlText.writeText(MainWindow.screenTexts.get("nothing_found"));
        }
    }

    public void drawTestTiles(Graphics g) {
        this.drawTile(g, "TILE_ADELIGER", 0, 0);
        this.drawTile(g, "TILE_MAGIER", 1, 0);
        this.drawTile(g, "TILE_PRIESTER", 2, 0);
        this.drawTile(g, "TILE_SOLDAT", 3, 0);
        this.drawTile(g, "TILE_DIEB", 4, 0);
        this.drawTile(g, "TILE_HANDWERKER", 5, 0);
        this.drawTile(g, "TILE_KAEMPFER", 6, 0);
        this.drawTile(g, "TILE_KOBOLD", 0, 1);
        this.drawTile(g, "TILE_GOLEM", 1, 1);
        this.drawTile(g, "TILE_ORK", 2, 1);
        this.drawTile(g, "TILE_TROLL", 3, 1);
        this.drawTile(g, "TILE_FLEDERMAUS", 4, 1);
        this.drawTile(g, "TILE_SPINNE", 5, 1);
        this.drawTile(g, "TILE_SCHLANGE", 6, 1);
        this.drawTile(g, "TILE_NESSIE", 7, 1);
        this.drawTile(g, "TILE_SKELETT", 8, 1);
        this.drawTile(g, "TILE_VAMPIR", 9, 1);
        this.drawTile(g, "TILE_KRAKE", 0, 2);
        this.drawTile(g, "TILE_DRACHE", 1, 2);
        this.drawTile(g, "TILE_SCHIFF", 2, 2);
        this.drawTile(g, "TILE_ZYKLOP", 3, 2);
        this.drawTile(g, "TILE_GEIST", 4, 2);
        this.drawTile(g, "TILE_DAEMON", 5, 2);
        this.drawTile(g, "TILE_BALROG", 6, 2);
        this.drawTile(g, "TILE_BLACKWIZARD", 7, 2);
        this.drawTile(g, "TILE_FEE", 0, 3);
        this.drawTile(g, "TILE_A", 0, 4);
        this.drawTile(g, "TILE_B", 1, 4);
        this.drawTile(g, "TILE_C", 2, 4);
        this.drawTile(g, "TILE_D", 3, 4);
        this.drawTile(g, "TILE_E", 4, 4);
        this.drawTile(g, "TILE_F", 5, 4);
        this.drawTile(g, "TILE_G", 6, 4);
        this.drawTile(g, "TILE_H", 7, 4);
        this.drawTile(g, "TILE_I", 8, 4);
        this.drawTile(g, "TILE_J", 9, 4);
        this.drawTile(g, "TILE_K", 0, 5);
        this.drawTile(g, "TILE_L", 1, 5);
        this.drawTile(g, "TILE_M", 2, 5);
        this.drawTile(g, "TILE_N", 3, 5);
        this.drawTile(g, "TILE_O", 4, 5);
        this.drawTile(g, "TILE_P", 5, 5);
        this.drawTile(g, "TILE_Q", 6, 5);
        this.drawTile(g, "TILE_R", 7, 5);
        this.drawTile(g, "TILE_S", 8, 5);
        this.drawTile(g, "TILE_T", 9, 5);
        this.drawTile(g, "TILE_U", 0, 6);
        this.drawTile(g, "TILE_V", 1, 6);
        this.drawTile(g, "TILE_W", 2, 6);
        this.drawTile(g, "TILE_X", 3, 6);
        this.drawTile(g, "TILE_Y", 4, 6);
        this.drawTile(g, "TILE_Z", 5, 6);
        this.drawTile(g, "TILE_WASSER_T", 0, 7);
        this.drawTile(g, "TILE_GRAS", 1, 7);
        this.drawTile(g, "TILE_SUMPF", 2, 7);
        this.drawTile(g, "TILE_BUSCH", 3, 7);
        this.drawTile(g, "TILE_EICHE", 4, 7);
        this.drawTile(g, "TILE_FICHTE", 5, 7);
        this.drawTile(g, "TILE_WEIDE", 6, 7);
        this.drawTile(g, "TILE_STEIN1", 7, 7);
        this.drawTile(g, "TILE_STEIN2", 8, 7);
        this.drawTile(g, "TILE_ZIEGELMAUER", 9, 7);
        this.drawTile(g, "TILE_MARMORMAUER", 0, 8);
        this.drawTile(g, "TILE_HOLZBODEN", 1, 8);
        this.drawTile(g, "TILE_HOLZWAND", 2, 8);
        this.drawTile(g, "TILE_WEG", 3, 8);
        this.drawTile(g, "TILE_BRUNNEN", 4, 8);
        this.drawTile(g, "TILE_LAGERFEUER", 5, 8);
        this.drawTile(g, "TILE_GRAB", 6, 8);
        this.drawTile(g, "TILE_TUER", 7, 8);
    }
}

