/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLParser {
    private static final long serialVersionUID = 1L;
    private DocumentBuilder builder;
    private Document document;
    private Element rootElement;

    public XMLParser() throws ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.builder = factory.newDocumentBuilder();
        this.document = this.builder.newDocument();
        this.rootElement = this.document.createElement("root");
        this.document.appendChild(this.rootElement);
        this.document.setStrictErrorChecking(false);
    }

    public void parseDocument(InputStream source) {
        try {
            this.document = this.builder.parse(source);
            this.document.setStrictErrorChecking(false);
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Node[] getNodes(String key) {
        ArrayList<Node> al = new ArrayList<Node>();
        NodeList nl = this.document.getLastChild().getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeName().trim().equals(key)) {
                al.add(n);
            }
            ++i;
        }
        Node[] nodes = new Node[al.size()];
        nodes = al.toArray(nodes);
        return nodes;
    }

    public Node[] getChildNodes(Node node) {
        NodeList nl = node.getChildNodes();
        ArrayList<Node> al = new ArrayList<Node>();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            al.add(n);
            ++i;
        }
        Node[] nodes = new Node[al.size()];
        nodes = al.toArray(nodes);
        return nodes;
    }

    public String getValue(Node key) {
        if (key.hasChildNodes()) {
            return key.getFirstChild().getNodeValue();
        }
        return null;
    }

    public Node getNodeForTheKey(Node[] nodes, String key) {
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node n3 = nodeArray[n2];
            if (n3.getNodeName().trim().equals(key)) {
                return n3;
            }
            ++n2;
        }
        return null;
    }

    public String getValue(Node[] nodes, String key) {
        Node n = this.getNodeForTheKey(nodes, key);
        if (n != null) {
            return this.getValue(n);
        }
        return null;
    }

    public Node getRootNode() {
        Node n = this.document.getFirstChild();
        return n;
    }

    public String getValue(String key) {
        NodeList nl = this.document.getLastChild().getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeName().trim().equals(key)) {
                return n.getFirstChild().getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public Node addChildNode(Node parentNode, String key, String value) {
        Element e = this.document.createElement(key);
        e.appendChild(this.document.createTextNode(value));
        parentNode.appendChild(e);
        return e;
    }

    public Node addChildNode(Node parentNode, String key, CDATASection value) {
        Element e = this.document.createElement(key);
        e.appendChild(value);
        parentNode.appendChild(e);
        return e;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public void sendDocumentInOutputStream(OutputStream out) throws IOException {
        try {
            StreamResult result = new StreamResult(out);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException ex) {
            System.out.println(ex.toString());
            throw new IOException(ex.getMessage());
        }
        catch (TransformerFactoryConfigurationError ex) {
            System.out.println(ex.toString());
            throw new IOException(ex.getMessage());
        }
        catch (TransformerException ex) {
            System.out.println(ex.toString());
            throw new IOException(ex.getMessage());
        }
    }

    public Document createEmptyDocument() {
        this.document = this.builder.newDocument();
        this.rootElement = this.document.createElement("root");
        this.document.appendChild(this.rootElement);
        return this.document;
    }
}

