/*
 * Decompiled with CFR 0.152.
 */
package tools;

import classes.Character;
import classes.Citizen;
import classes.Dungeon;
import classes.Dungeonlevel;
import classes.Item;
import classes.Klasse;
import classes.MonsterType;
import classes.NameMap;
import classes.NameMapTile;
import classes.Profession;
import classes.Ruestung;
import classes.Settlement;
import classes.Spell;
import classes.Spielstand;
import classes.SurfaceMap;
import classes.TacticScreen;
import classes.Tile;
import classes.Waffe;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import tools.HelpMethods;
import tools.XMLParser;
import ui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameXMLDocument {
    public XMLParser parser;
    public Node root;
    public Document doc;

    public GameXMLDocument(String xmlFileName) {
        this.doc = this.loadXmlDoc(xmlFileName);
    }

    public GameXMLDocument(URL urlXmlFileName) {
        this.doc = this.loadXmlDoc(urlXmlFileName);
    }

    private Document loadXmlDoc(URL urlGameXML) {
        block18: {
            try {
                this.parser = new XMLParser();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            this.root = this.parser.getRootNode();
            InputStream fis = null;
            URLConnection conn = null;
            try {
                conn = urlGameXML.openConnection();
                conn.connect();
                fis = conn.getInputStream();
                this.parser.parseDocument(fis);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    fis.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                break block18;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.parser.getDocument();
    }

    private Document loadXmlDoc(String xmlFileName) {
        try {
            this.parser = new XMLParser();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.root = this.parser.getRootNode();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(xmlFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.parser.parseDocument(fis);
        return this.parser.getDocument();
    }

    public SurfaceMap getSurfaceMap() {
        SurfaceMap result = new SurfaceMap();
        Node[] nodes = this.parser.getNodes("surface_map");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        result.map = new char[subNodes.length][subNodes[1].getTextContent().length()];
        result.height = 0;
        int ic = 0;
        while (ic < subNodes.length) {
            if (subNodes[ic].getNodeName().compareTo("row") == 0) {
                ++result.height;
            }
            ++ic;
        }
        result.width = subNodes[1].getTextContent().length();
        int y = 0;
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("row") == 0) {
                String strRow = subNodes[i].getTextContent();
                int x = 0;
                while (x < result.width) {
                    try {
                        result.map[x][y] = strRow.charAt(x);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        e.printStackTrace();
                        System.out.println("x:" + x + " y:" + y);
                        System.exit(0);
                    }
                    ++x;
                }
                ++y;
            }
            if (subNodes[i].getNodeName().equalsIgnoreCase("items")) {
                Node[] itemNodes = this.parser.getChildNodes(subNodes[i]);
                int iItems = 0;
                while (iItems < itemNodes.length) {
                    if (itemNodes[iItems].getNodeName().equalsIgnoreCase("item")) {
                        NamedNodeMap attr = itemNodes[iItems].getAttributes();
                        Item item = new Item(HelpMethods.replaceUmlauts(attr.getNamedItem("name").getNodeValue()), Integer.parseInt(attr.getNamedItem("x").getNodeValue()), Integer.parseInt(attr.getNamedItem("y").getNodeValue()), attr.getNamedItem("effect").getNodeValue(), attr.getNamedItem("param").getNodeValue());
                        result.items.add(item);
                    }
                    ++iItems;
                }
            }
            ++i;
        }
        return result;
    }

    public NameMap getNameMap() {
        NameMap result = new NameMap();
        Node[] nodes = this.parser.getNodes("name_map");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        result.map = new char[subNodes.length][subNodes[1].getTextContent().length()];
        result.height = 0;
        int ic = 0;
        while (ic < subNodes.length) {
            if (subNodes[ic].getNodeName().compareTo("row") == 0) {
                ++result.height;
            }
            ++ic;
        }
        result.width = subNodes[1].getTextContent().length();
        int y = 0;
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("row") == 0) {
                String strRow = subNodes[i].getTextContent();
                int x = 0;
                while (x < result.width) {
                    try {
                        result.map[x][y] = strRow.charAt(x);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        e.printStackTrace();
                        System.out.println("x:" + x + " y:" + y);
                        System.exit(0);
                    }
                    ++x;
                }
                ++y;
            }
            if (subNodes[i].getNodeName().equalsIgnoreCase("name_map_tiles")) {
                Node[] itemNodes = this.parser.getChildNodes(subNodes[i]);
                int iItems = 0;
                while (iItems < itemNodes.length) {
                    if (itemNodes[iItems].getNodeName().equalsIgnoreCase("name_map_tile")) {
                        NamedNodeMap attr = itemNodes[iItems].getAttributes();
                        result.nameMapTiles.put(attr.getNamedItem("map_tile").getNodeValue(), new NameMapTile(attr.getNamedItem("ambush") != null ? Integer.parseInt(attr.getNamedItem("ambush").getNodeValue()) : 0, attr.getNamedItem("monst_typ") != null ? Integer.parseInt(attr.getNamedItem("monst_typ").getNodeValue()) : 0, attr.getNamedItem("monst_cnt") != null ? Integer.parseInt(attr.getNamedItem("monst_cnt").getNodeValue()) : 0, HelpMethods.replaceUmlauts(attr.getNamedItem("text").getNodeValue())));
                    }
                    ++iItems;
                }
            }
            ++i;
        }
        return result;
    }

    public HashMap<Integer, MonsterType> getMonsterTypes() {
        Node[] nodes = this.parser.getNodes("monstertypes");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arMonsterNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("monstertype") == 0) {
                arMonsterNodes.add(subNodes[i]);
            }
            ++i;
        }
        HashMap<Integer, MonsterType> result = new HashMap<Integer, MonsterType>();
        int i2 = 0;
        while (i2 < arMonsterNodes.size()) {
            NamedNodeMap attr = ((Node)arMonsterNodes.get(i2)).getAttributes();
            result.put(attr.getNamedItem("id") != null ? Integer.parseInt(attr.getNamedItem("id").getNodeValue()) : 0, new MonsterType(HelpMethods.replaceUmlauts(attr.getNamedItem("name").getNodeValue()), HelpMethods.replaceUmlauts(attr.getNamedItem("name_mz").getNodeValue()), attr.getNamedItem("tile").getNodeValue(), attr.getNamedItem("spawnarea") != null ? (char)attr.getNamedItem("spawnarea").getNodeValue().charAt(0) : (char)'@', attr.getNamedItem("maxhp") != null ? Integer.parseInt(attr.getNamedItem("maxhp").getNodeValue()) : 0, attr.getNamedItem("st") != null ? Integer.parseInt(attr.getNamedItem("st").getNodeValue()) : 0, attr.getNamedItem("dx") != null ? Integer.parseInt(attr.getNamedItem("dx").getNodeValue()) : 0, attr.getNamedItem("mg") != null ? Integer.parseInt(attr.getNamedItem("mg").getNodeValue()) : 0, attr.getNamedItem("attack") != null ? HelpMethods.replaceUmlauts(attr.getNamedItem("attack").getNodeValue()) : "", attr.getNamedItem("exp") != null ? Integer.parseInt(attr.getNamedItem("exp").getNodeValue()) : 0, attr.getNamedItem("poison") != null ? attr.getNamedItem("poison").getNodeValue().equalsIgnoreCase("true") : false, attr.getNamedItem("casts") != null ? HelpMethods.replaceUmlauts(attr.getNamedItem("casts").getNodeValue()) : "", attr.getNamedItem("waffe") != null ? HelpMethods.replaceUmlauts(attr.getNamedItem("waffe").getNodeValue()) : "", attr.getNamedItem("maxgold") != null ? Integer.parseInt(attr.getNamedItem("maxgold").getNodeValue()) : 0));
            ++i2;
        }
        return result;
    }

    public Tile[] getTiles() {
        Node[] nodes = this.parser.getNodes("tiles");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arTileNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("tile") == 0) {
                arTileNodes.add(subNodes[i]);
            }
            ++i;
        }
        Tile[] result = new Tile[arTileNodes.size()];
        int i2 = 0;
        while (i2 < arTileNodes.size()) {
            NamedNodeMap attr = ((Node)arTileNodes.get(i2)).getAttributes();
            result[i2] = new Tile(Integer.parseInt(attr.getNamedItem("type").getNodeValue()), attr.getNamedItem("name").getNodeValue(), attr.getNamedItem("gif_file").getNodeValue(), attr.getNamedItem("map_char") != null ? (char)attr.getNamedItem("map_char").getNodeValue().charAt(0) : (char)'@', attr.getNamedItem("betretbar") != null ? attr.getNamedItem("betretbar").getNodeValue() : "true", attr.getNamedItem("schiffbar") != null ? attr.getNamedItem("schiffbar").getNodeValue() : "false", attr.getNamedItem("transparent") != null ? attr.getNamedItem("transparent").getNodeValue() : "true");
            ++i2;
        }
        return result;
    }

    public Settlement[] getSettlements() {
        String name = "";
        int posx = 0;
        int posy = 0;
        int startposx = 0;
        int startposy = 0;
        char[][] map = null;
        int mapHeight = 0;
        int mapWidth = 0;
        char margintile = '@';
        ArrayList<Citizen> citizens = new ArrayList<Citizen>();
        ArrayList<Item> items = new ArrayList<Item>();
        Node[] settlements = this.parser.getNodes("settlement");
        Settlement[] results = new Settlement[settlements.length];
        int iSett = 0;
        while (iSett < settlements.length) {
            NamedNodeMap attr = settlements[iSett].getAttributes();
            name = attr.getNamedItem("name").getNodeValue();
            posx = Integer.parseInt(attr.getNamedItem("posx").getNodeValue());
            posy = Integer.parseInt(attr.getNamedItem("posy").getNodeValue());
            startposx = Integer.parseInt(attr.getNamedItem("startposx").getNodeValue());
            startposy = Integer.parseInt(attr.getNamedItem("startposy").getNodeValue());
            margintile = attr.getNamedItem("margintile").getNodeValue().charAt(0);
            Node[] settNodes = this.parser.getChildNodes(settlements[iSett]);
            citizens = new ArrayList();
            items = new ArrayList();
            int i = 0;
            while (i < settNodes.length) {
                Node[] subNodes;
                if (settNodes[i].getNodeName().compareTo("map") == 0) {
                    subNodes = this.parser.getChildNodes(settNodes[i]);
                    mapHeight = 0;
                    int ic = 0;
                    while (ic < subNodes.length) {
                        if (subNodes[ic].getNodeName().compareTo("row") == 0) {
                            ++mapHeight;
                        }
                        ++ic;
                    }
                    mapWidth = subNodes[1].getTextContent().length();
                    map = new char[mapWidth][mapHeight];
                    int y = 0;
                    int i2 = 0;
                    while (i2 < subNodes.length) {
                        if (subNodes[i2].getNodeName().compareTo("row") == 0) {
                            String strRow = subNodes[i2].getTextContent();
                            int x = 0;
                            while (x < mapWidth) {
                                try {
                                    map[x][y] = strRow.charAt(x);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    e.printStackTrace();
                                    System.out.println("x:" + x + " y:" + y);
                                    System.exit(0);
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++i2;
                    }
                }
                if (settNodes[i].getNodeName().equalsIgnoreCase("citizens")) {
                    subNodes = this.parser.getChildNodes(settNodes[i]);
                    int i2 = 0;
                    while (i2 < subNodes.length) {
                        if (subNodes[i2].getNodeName().equalsIgnoreCase("citizen")) {
                            NamedNodeMap attr2 = subNodes[i2].getAttributes();
                            Node[] citNodes = this.parser.getChildNodes(subNodes[i2]);
                            ArrayList<String> cittexts = new ArrayList<String>();
                            ArrayList<String> keys = new ArrayList<String>();
                            ArrayList<Integer> actions = new ArrayList<Integer>();
                            ArrayList<String> param = new ArrayList<String>();
                            int i3 = 0;
                            while (i3 < citNodes.length) {
                                if (citNodes[i3].getNodeName().equalsIgnoreCase("cittext")) {
                                    NamedNodeMap attr3 = citNodes[i3].getAttributes();
                                    cittexts.add(HelpMethods.replaceUmlauts(attr3.getNamedItem("text").getNodeValue()));
                                    keys.add(HelpMethods.replaceUmlauts(attr3.getNamedItem("key").getNodeValue()));
                                    actions.add(Integer.parseInt(attr3.getNamedItem("action").getNodeValue()));
                                    param.add(HelpMethods.replaceUmlauts(attr3.getNamedItem("param").getNodeValue()));
                                }
                                ++i3;
                            }
                            Citizen cit = new Citizen(HelpMethods.replaceUmlauts(attr2.getNamedItem("name").getNodeValue()), attr2.getNamedItem("tile").getNodeValue(), attr2.getNamedItem("maptile").getNodeValue().charAt(0), HelpMethods.replaceUmlauts(attr2.getNamedItem("text").getNodeValue()), map, cittexts, keys, actions, param);
                            citizens.add(cit);
                        }
                        ++i2;
                    }
                }
                if (settNodes[i].getNodeName().equalsIgnoreCase("items")) {
                    Node[] itemNodes = this.parser.getChildNodes(settNodes[i]);
                    int iItems = 0;
                    while (iItems < itemNodes.length) {
                        if (itemNodes[iItems].getNodeName().equalsIgnoreCase("item")) {
                            NamedNodeMap attr3 = itemNodes[iItems].getAttributes();
                            Item item = new Item(HelpMethods.replaceUmlauts(attr3.getNamedItem("name").getNodeValue()), Integer.parseInt(attr3.getNamedItem("x").getNodeValue()), Integer.parseInt(attr3.getNamedItem("y").getNodeValue()), attr3.getNamedItem("effect").getNodeValue(), HelpMethods.replaceUmlauts(attr3.getNamedItem("param").getNodeValue()));
                            items.add(item);
                        }
                        ++iItems;
                    }
                }
                ++i;
            }
            results[iSett] = new Settlement(name, posx, posy, startposx, startposy, map, mapWidth, mapHeight, margintile, citizens, items);
            ++iSett;
        }
        return results;
    }

    public Dungeon[] getDungeons() {
        String name = "";
        int posx = 0;
        int posy = 0;
        int wind = 0;
        Dungeonlevel[] dungeonlevels = null;
        Node[] dungeons = this.parser.getNodes("dungeon");
        Dungeon[] results = new Dungeon[dungeons.length];
        int iDung = 0;
        while (iDung < dungeons.length) {
            NamedNodeMap attr = dungeons[iDung].getAttributes();
            name = HelpMethods.replaceUmlauts(attr.getNamedItem("name").getNodeValue());
            posx = Integer.parseInt(attr.getNamedItem("posx").getNodeValue());
            posy = Integer.parseInt(attr.getNamedItem("posy").getNodeValue());
            wind = Integer.parseInt(attr.getNamedItem("wind").getNodeValue());
            Node[] dungNodes = this.parser.getChildNodes(dungeons[iDung]);
            int levelCount = 0;
            int ic = 0;
            while (ic < dungNodes.length) {
                if (dungNodes[ic].getNodeName().compareTo("level") == 0) {
                    ++levelCount;
                }
                ++ic;
            }
            dungeonlevels = new Dungeonlevel[levelCount];
            levelCount = 0;
            int i = 0;
            while (i < dungNodes.length) {
                if (dungNodes[i].getNodeName().compareTo("level") == 0) {
                    dungeonlevels[levelCount++] = this.getDungeonlevel(dungNodes[i]);
                }
                ++i;
            }
            results[iDung] = new Dungeon(name, posx, posy, wind, dungeonlevels);
            ++iDung;
        }
        return results;
    }

    private Dungeonlevel getDungeonlevel(Node dungNode) {
        Dungeonlevel result = null;
        int mapHeight = 0;
        int mapWidth = 0;
        char[][] map = null;
        ArrayList<Item> items = new ArrayList<Item>();
        TacticScreen[] tacticscreens = null;
        int[] monsters = null;
        int monsterCount = 1;
        Node[] subNodes = this.parser.getChildNodes(dungNode);
        mapHeight = 0;
        int ic = 0;
        while (ic < subNodes.length) {
            if (subNodes[ic].getNodeName().compareTo("row") == 0) {
                ++mapHeight;
            }
            ++ic;
        }
        mapWidth = subNodes[1].getTextContent().length();
        map = new char[mapWidth][mapHeight];
        int y = 0;
        int i2 = 0;
        while (i2 < subNodes.length) {
            if (subNodes[i2].getNodeName().compareTo("row") == 0) {
                String strRow = subNodes[i2].getTextContent();
                int x = 0;
                while (x < mapWidth) {
                    try {
                        map[x][y] = strRow.charAt(x);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        e.printStackTrace();
                        System.out.println("x:" + x + " y:" + y);
                        System.exit(0);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        e.printStackTrace();
                        System.out.println("x:" + x + " y:" + y);
                        System.exit(0);
                    }
                    ++x;
                }
                ++y;
            }
            if (subNodes[i2].getNodeName().equalsIgnoreCase("items")) {
                Node[] itemNodes = this.parser.getChildNodes(subNodes[i2]);
                int iItems = 0;
                while (iItems < itemNodes.length) {
                    if (itemNodes[iItems].getNodeName().equalsIgnoreCase("item")) {
                        NamedNodeMap attr3 = itemNodes[iItems].getAttributes();
                        Item item = new Item(HelpMethods.replaceUmlauts(attr3.getNamedItem("name").getNodeValue()), Integer.parseInt(attr3.getNamedItem("x").getNodeValue()), Integer.parseInt(attr3.getNamedItem("y").getNodeValue()), attr3.getNamedItem("effect").getNodeValue(), attr3.getNamedItem("param").getNodeValue());
                        items.add(item);
                    }
                    ++iItems;
                }
            }
            if (subNodes[i2].getNodeName().equalsIgnoreCase("tacticscreens")) {
                tacticscreens = this.getTacticScreens(subNodes[i2]);
            }
            if (subNodes[i2].getNodeName().equalsIgnoreCase("monsters")) {
                NamedNodeMap attr = subNodes[i2].getAttributes();
                monsterCount = Integer.parseInt(attr.getNamedItem("count").getNodeValue());
                String strMonsters = subNodes[i2].getTextContent();
                String[] arStrMonsters = strMonsters.split(",");
                monsters = new int[arStrMonsters.length];
                int i = 0;
                while (i < arStrMonsters.length) {
                    monsters[i] = Integer.parseInt(arStrMonsters[i]);
                    ++i;
                }
            }
            ++i2;
        }
        result = new Dungeonlevel(map, mapHeight, mapWidth, items, tacticscreens, monsters, monsterCount);
        return result;
    }

    public Klasse[] getKlassen() {
        Node[] nodes = this.parser.getNodes("klassen");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("klasse") == 0) {
                arNodes.add(subNodes[i]);
            }
            ++i;
        }
        Klasse[] result = new Klasse[arNodes.size()];
        int i2 = 0;
        while (i2 < arNodes.size()) {
            NamedNodeMap attr = ((Node)arNodes.get(i2)).getAttributes();
            result[i2] = new Klasse(HelpMethods.replaceUmlauts(attr.getNamedItem("name").getNodeValue()), attr.getNamedItem("hp") != null ? Integer.parseInt(attr.getNamedItem("hp").getNodeValue()) : 0, attr.getNamedItem("st") != null ? Integer.parseInt(attr.getNamedItem("st").getNodeValue()) : 0, attr.getNamedItem("dx") != null ? Integer.parseInt(attr.getNamedItem("dx").getNodeValue()) : 0, attr.getNamedItem("mg") != null ? Integer.parseInt(attr.getNamedItem("mg").getNodeValue()) : 0);
            ++i2;
        }
        return result;
    }

    public Ruestung[] getRuestungen() {
        Node[] nodes = this.parser.getNodes("ruestungen");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("ruestung") == 0) {
                arNodes.add(subNodes[i]);
            }
            ++i;
        }
        Ruestung[] result = new Ruestung[arNodes.size()];
        int i2 = 0;
        while (i2 < arNodes.size()) {
            NamedNodeMap attr = ((Node)arNodes.get(i2)).getAttributes();
            result[i2] = new Ruestung(HelpMethods.replaceUmlauts(attr.getNamedItem("name").getNodeValue()), attr.getNamedItem("id") != null ? Integer.parseInt(attr.getNamedItem("id").getNodeValue()) : 0, attr.getNamedItem("schutz") != null ? Integer.parseInt(attr.getNamedItem("schutz").getNodeValue()) : 0, attr.getNamedItem("preis") != null ? Integer.parseInt(attr.getNamedItem("preis").getNodeValue()) : 0);
            ++i2;
        }
        return result;
    }

    public Waffe[] getWaffen() {
        Node[] nodes = this.parser.getNodes("waffen");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("waffe") == 0) {
                arNodes.add(subNodes[i]);
            }
            ++i;
        }
        Waffe[] result = new Waffe[arNodes.size()];
        int i2 = 0;
        while (i2 < arNodes.size()) {
            NamedNodeMap attr = ((Node)arNodes.get(i2)).getAttributes();
            result[i2] = new Waffe(HelpMethods.replaceUmlauts(attr.getNamedItem("name").getNodeValue()), attr.getNamedItem("typ") != null ? Integer.parseInt(attr.getNamedItem("typ").getNodeValue()) : 0, attr.getNamedItem("id") != null ? Integer.parseInt(attr.getNamedItem("id").getNodeValue()) : 0, attr.getNamedItem("st") != null ? Integer.parseInt(attr.getNamedItem("st").getNodeValue()) : 0, attr.getNamedItem("preis") != null ? Integer.parseInt(attr.getNamedItem("preis").getNodeValue()) : 0);
            ++i2;
        }
        return result;
    }

    public Profession[] getProfession() {
        Node[] nodes = this.parser.getNodes("professionen");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("profession") == 0) {
                arNodes.add(subNodes[i]);
            }
            ++i;
        }
        Profession[] result = new Profession[arNodes.size()];
        int i2 = 0;
        while (i2 < arNodes.size()) {
            NamedNodeMap attr = ((Node)arNodes.get(i2)).getAttributes();
            result[i2] = new Profession(HelpMethods.replaceUmlauts(attr.getNamedItem("name").getNodeValue()), attr.getNamedItem("rendertile").getNodeValue(), attr.getNamedItem("ex1") != null ? Integer.parseInt(attr.getNamedItem("ex1").getNodeValue()) : 0, HelpMethods.replaceUmlauts(attr.getNamedItem("level1").getNodeValue()), attr.getNamedItem("ex2") != null ? Integer.parseInt(attr.getNamedItem("ex2").getNodeValue()) : 0, HelpMethods.replaceUmlauts(attr.getNamedItem("level2").getNodeValue()), attr.getNamedItem("ex3") != null ? Integer.parseInt(attr.getNamedItem("ex3").getNodeValue()) : 0, HelpMethods.replaceUmlauts(attr.getNamedItem("level3").getNodeValue()), attr.getNamedItem("ex4") != null ? Integer.parseInt(attr.getNamedItem("ex4").getNodeValue()) : 0, HelpMethods.replaceUmlauts(attr.getNamedItem("level4").getNodeValue()), attr.getNamedItem("ex5") != null ? Integer.parseInt(attr.getNamedItem("ex5").getNodeValue()) : 0, HelpMethods.replaceUmlauts(attr.getNamedItem("level5").getNodeValue()), attr.getNamedItem("ex6") != null ? Integer.parseInt(attr.getNamedItem("ex6").getNodeValue()) : 0, HelpMethods.replaceUmlauts(attr.getNamedItem("level6").getNodeValue()), attr.getNamedItem("ex7") != null ? Integer.parseInt(attr.getNamedItem("ex7").getNodeValue()) : 0, HelpMethods.replaceUmlauts(attr.getNamedItem("level7").getNodeValue()), attr.getNamedItem("ex8") != null ? Integer.parseInt(attr.getNamedItem("ex8").getNodeValue()) : 0, HelpMethods.replaceUmlauts(attr.getNamedItem("level8").getNodeValue()), attr.getNamedItem("growdouble").getNodeValue(), attr.getNamedItem("ruestung") != null ? Integer.parseInt(attr.getNamedItem("ruestung").getNodeValue()) : 0, attr.getNamedItem("waffenTyp") != null ? Integer.parseInt(attr.getNamedItem("waffenTyp").getNodeValue()) : 0, attr.getNamedItem("kistoff").getNodeValue(), attr.getNamedItem("tueroff").getNodeValue(), attr.getNamedItem("toeten").getNodeValue(), HelpMethods.replaceUmlauts(attr.getNamedItem("noweapon").getNodeValue()));
            ++i2;
        }
        return result;
    }

    public Spielstand getSpielstand() {
        Node[] nodes = this.parser.getNodes("spielstand");
        NamedNodeMap attrSpielst = nodes[0].getAttributes();
        int posx = Integer.parseInt(attrSpielst.getNamedItem("posx").getNodeValue());
        int posy = Integer.parseInt(attrSpielst.getNamedItem("posy").getNodeValue());
        int posshipx = Integer.parseInt(attrSpielst.getNamedItem("posshipx").getNodeValue());
        int posshipy = Integer.parseInt(attrSpielst.getNamedItem("posshipy").getNodeValue());
        int gold = Integer.parseInt(attrSpielst.getNamedItem("gold").getNodeValue());
        int food = Integer.parseInt(attrSpielst.getNamedItem("food").getNodeValue());
        int keys = Integer.parseInt(attrSpielst.getNamedItem("keys").getNodeValue());
        int torches = Integer.parseInt(attrSpielst.getNamedItem("torches").getNodeValue());
        int textsize = Integer.parseInt(attrSpielst.getNamedItem("textsize").getNodeValue());
        int onBoard = Integer.parseInt(attrSpielst.getNamedItem("onBoard").getNodeValue());
        int aktSettlement = Integer.parseInt(attrSpielst.getNamedItem("aktSettlement").getNodeValue());
        int xSettPosition = Integer.parseInt(attrSpielst.getNamedItem("xSettPosition").getNodeValue());
        int ySettPosition = Integer.parseInt(attrSpielst.getNamedItem("ySettPosition").getNodeValue());
        int aktDungeon = Integer.parseInt(attrSpielst.getNamedItem("aktDungeon").getNodeValue());
        int xDungPosition = Integer.parseInt(attrSpielst.getNamedItem("xDungPosition").getNodeValue());
        int yDungPosition = Integer.parseInt(attrSpielst.getNamedItem("yDungPosition").getNodeValue());
        int aktDungLevel = Integer.parseInt(attrSpielst.getNamedItem("aktDungLevel").getNodeValue());
        int dungViewDirection = Integer.parseInt(attrSpielst.getNamedItem("dungViewDirection").getNodeValue());
        int light = Integer.parseInt(attrSpielst.getNamedItem("light").getNodeValue());
        int renderMode = Integer.parseInt(attrSpielst.getNamedItem("renderMode").getNodeValue());
        int oldRenderMode = Integer.parseInt(attrSpielst.getNamedItem("oldRenderMode").getNodeValue());
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("character") == 0) {
                arNodes.add(subNodes[i]);
            }
            ++i;
        }
        Character[] characters = new Character[arNodes.size()];
        int i2 = 0;
        while (i2 < arNodes.size()) {
            NamedNodeMap attr = ((Node)arNodes.get(i2)).getAttributes();
            characters[i2] = new Character(HelpMethods.replaceUmlauts(attr.getNamedItem("name").getNodeValue()), attr.getNamedItem("kl") != null ? Integer.parseInt(attr.getNamedItem("kl").getNodeValue()) : 0, attr.getNamedItem("pr") != null ? Integer.parseInt(attr.getNamedItem("pr").getNodeValue()) : 0, attr.getNamedItem("lv") != null ? Integer.parseInt(attr.getNamedItem("lv").getNodeValue()) : 0, attr.getNamedItem("akthp") != null ? Integer.parseInt(attr.getNamedItem("akthp").getNodeValue()) : 0, attr.getNamedItem("aktmg") != null ? Integer.parseInt(attr.getNamedItem("aktmg").getNodeValue()) : 0, attr.getNamedItem("hp") != null ? Integer.parseInt(attr.getNamedItem("hp").getNodeValue()) : 0, attr.getNamedItem("st") != null ? Integer.parseInt(attr.getNamedItem("st").getNodeValue()) : 0, attr.getNamedItem("dx") != null ? Integer.parseInt(attr.getNamedItem("dx").getNodeValue()) : 0, attr.getNamedItem("mg") != null ? Integer.parseInt(attr.getNamedItem("mg").getNodeValue()) : 0, attr.getNamedItem("rs") != null ? Integer.parseInt(attr.getNamedItem("rs").getNodeValue()) : 0, attr.getNamedItem("wf") != null ? Integer.parseInt(attr.getNamedItem("wf").getNodeValue()) : 0, attr.getNamedItem("exp") != null ? Integer.parseInt(attr.getNamedItem("exp").getNodeValue()) : 0, attr.getNamedItem("zustand") != null ? attr.getNamedItem("zustand").getNodeValue().charAt(0) : (char)'\u0000');
            ++i2;
        }
        ArrayList<Waffe> invWaffen = new ArrayList<Waffe>();
        ArrayList<Ruestung> invRuestung = new ArrayList<Ruestung>();
        ArrayList<Item> invItems = new ArrayList<Item>();
        arNodes = new ArrayList();
        int i3 = 0;
        while (i3 < subNodes.length) {
            if (subNodes[i3].getNodeName().compareTo("inv_waffen") == 0) {
                arNodes.add(subNodes[i3]);
            }
            ++i3;
        }
        String strInvCsv = null;
        int i4 = 0;
        while (i4 < arNodes.size()) {
            strInvCsv = ((Node)arNodes.get(i4)).getTextContent();
            ++i4;
        }
        String[] arCsv = strInvCsv.split(",");
        int i5 = 0;
        while (i5 < arCsv.length) {
            if (arCsv[i5].length() > 0) {
                Waffe waffe = MainWindow.waffen[Integer.parseInt(arCsv[i5])];
                invWaffen.add(waffe);
            }
            ++i5;
        }
        arNodes = new ArrayList();
        i5 = 0;
        while (i5 < subNodes.length) {
            if (subNodes[i5].getNodeName().compareTo("inv_ruest") == 0) {
                arNodes.add(subNodes[i5]);
            }
            ++i5;
        }
        strInvCsv = null;
        i5 = 0;
        while (i5 < arNodes.size()) {
            strInvCsv = ((Node)arNodes.get(i5)).getTextContent();
            ++i5;
        }
        arCsv = strInvCsv.split(",");
        i5 = 0;
        while (i5 < arCsv.length) {
            if (arCsv[i5].length() > 0) {
                Ruestung ruest = MainWindow.ruestungen[Integer.parseInt(arCsv[i5])];
                invRuestung.add(ruest);
            }
            ++i5;
        }
        arNodes = new ArrayList();
        i5 = 0;
        while (i5 < subNodes.length) {
            if (subNodes[i5].getNodeName().compareTo("inv_items") == 0) {
                arNodes.add(subNodes[i5]);
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < arNodes.size()) {
            Node[] itemNodes = this.parser.getChildNodes((Node)arNodes.get(i5));
            int iItems = 0;
            while (iItems < itemNodes.length) {
                if (itemNodes[iItems].getNodeName().equalsIgnoreCase("item")) {
                    NamedNodeMap attr3 = itemNodes[iItems].getAttributes();
                    Item item = new Item(HelpMethods.replaceUmlauts(attr3.getNamedItem("name").getNodeValue()), Integer.parseInt(attr3.getNamedItem("x").getNodeValue()), Integer.parseInt(attr3.getNamedItem("y").getNodeValue()), attr3.getNamedItem("effect").getNodeValue(), HelpMethods.replaceUmlauts(attr3.getNamedItem("param").getNodeValue()));
                    invItems.add(item);
                }
                ++iItems;
            }
            ++i5;
        }
        Spielstand result = new Spielstand(posx, posy, posshipx, posshipy, gold, food, keys, torches, textsize, onBoard, aktSettlement, xSettPosition, ySettPosition, aktDungeon, xDungPosition, yDungPosition, aktDungLevel, dungViewDirection, light, renderMode, oldRenderMode, invWaffen, invRuestung, invItems, characters);
        return result;
    }

    public TacticScreen[] getTacticScreens(Node parent) {
        String name = "";
        int type = 0;
        int mapHeight = 0;
        int mapWidth = 0;
        char maptile = '\u0000';
        char[][] map = null;
        Node[] tacticScreens = null;
        if (parent == null) {
            tacticScreens = this.parser.getNodes("tacticscreen");
        } else {
            ArrayList<Node> alTacScreens = new ArrayList<Node>();
            NodeList nl = parent.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node item = nl.item(i);
                if (item.getNodeName().equalsIgnoreCase("tacticscreen")) {
                    alTacScreens.add(item);
                }
                ++i;
            }
            tacticScreens = new Node[alTacScreens.size()];
            i = 0;
            while (i < alTacScreens.size()) {
                tacticScreens[i] = (Node)alTacScreens.get(i);
                ++i;
            }
        }
        TacticScreen[] results = new TacticScreen[tacticScreens.length];
        int iTacS = 0;
        while (iTacS < tacticScreens.length) {
            NamedNodeMap attr = tacticScreens[iTacS].getAttributes();
            name = attr.getNamedItem("name").getNodeValue();
            type = Integer.parseInt(attr.getNamedItem("type").getNodeValue());
            maptile = attr.getNamedItem("maptile").getNodeValue().charAt(0);
            int c1x = Integer.parseInt(attr.getNamedItem("c1x").getNodeValue());
            int c1y = Integer.parseInt(attr.getNamedItem("c1y").getNodeValue());
            int c2x = Integer.parseInt(attr.getNamedItem("c2x").getNodeValue());
            int c2y = Integer.parseInt(attr.getNamedItem("c2y").getNodeValue());
            int c3x = Integer.parseInt(attr.getNamedItem("c3x").getNodeValue());
            int c3y = Integer.parseInt(attr.getNamedItem("c3y").getNodeValue());
            int c4x = Integer.parseInt(attr.getNamedItem("c4x").getNodeValue());
            int c4y = Integer.parseInt(attr.getNamedItem("c4y").getNodeValue());
            int m1x = Integer.parseInt(attr.getNamedItem("m01x").getNodeValue());
            int m1y = Integer.parseInt(attr.getNamedItem("m01y").getNodeValue());
            int m2x = Integer.parseInt(attr.getNamedItem("m02x").getNodeValue());
            int m2y = Integer.parseInt(attr.getNamedItem("m02y").getNodeValue());
            int m3x = Integer.parseInt(attr.getNamedItem("m03x").getNodeValue());
            int m3y = Integer.parseInt(attr.getNamedItem("m03y").getNodeValue());
            int m4x = Integer.parseInt(attr.getNamedItem("m04x").getNodeValue());
            int m4y = Integer.parseInt(attr.getNamedItem("m04y").getNodeValue());
            int m5x = Integer.parseInt(attr.getNamedItem("m05x").getNodeValue());
            int m5y = Integer.parseInt(attr.getNamedItem("m05y").getNodeValue());
            int m6x = Integer.parseInt(attr.getNamedItem("m06x").getNodeValue());
            int m6y = Integer.parseInt(attr.getNamedItem("m06y").getNodeValue());
            int m7x = Integer.parseInt(attr.getNamedItem("m07x").getNodeValue());
            int m7y = Integer.parseInt(attr.getNamedItem("m07y").getNodeValue());
            int m8x = Integer.parseInt(attr.getNamedItem("m08x").getNodeValue());
            int m8y = Integer.parseInt(attr.getNamedItem("m08y").getNodeValue());
            int m9x = Integer.parseInt(attr.getNamedItem("m09x").getNodeValue());
            int m9y = Integer.parseInt(attr.getNamedItem("m09y").getNodeValue());
            int m10x = Integer.parseInt(attr.getNamedItem("m10x").getNodeValue());
            int m10y = Integer.parseInt(attr.getNamedItem("m10y").getNodeValue());
            int m11x = Integer.parseInt(attr.getNamedItem("m11x").getNodeValue());
            int m11y = Integer.parseInt(attr.getNamedItem("m11y").getNodeValue());
            int m12x = Integer.parseInt(attr.getNamedItem("m12x").getNodeValue());
            int m12y = Integer.parseInt(attr.getNamedItem("m12y").getNodeValue());
            Node[] tacSNodes = this.parser.getChildNodes(tacticScreens[iTacS]);
            int i = 0;
            while (i < tacSNodes.length) {
                if (tacSNodes[i].getNodeName().compareTo("map") == 0) {
                    Node[] subNodes = this.parser.getChildNodes(tacSNodes[i]);
                    mapHeight = 0;
                    int ic = 0;
                    while (ic < subNodes.length) {
                        if (subNodes[ic].getNodeName().compareTo("row") == 0) {
                            ++mapHeight;
                        }
                        ++ic;
                    }
                    mapWidth = subNodes[1].getTextContent().length();
                    map = new char[mapWidth][mapHeight];
                    int y = 0;
                    int i2 = 0;
                    while (i2 < subNodes.length) {
                        if (subNodes[i2].getNodeName().compareTo("row") == 0) {
                            String strRow = subNodes[i2].getTextContent();
                            int x = 0;
                            while (x < mapWidth) {
                                try {
                                    map[x][y] = strRow.charAt(x);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    e.printStackTrace();
                                    System.out.println("x:" + x + " y:" + y);
                                    System.exit(0);
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++i2;
                    }
                }
                ++i;
            }
            results[iTacS] = new TacticScreen(name, map, mapHeight, mapWidth, type, maptile);
            results[iTacS].c1x = c1x;
            results[iTacS].c1y = c1y;
            results[iTacS].c2x = c2x;
            results[iTacS].c2y = c2y;
            results[iTacS].c3x = c3x;
            results[iTacS].c3y = c3y;
            results[iTacS].c4x = c4x;
            results[iTacS].c4y = c4y;
            results[iTacS].m1x = m1x;
            results[iTacS].m1y = m1y;
            results[iTacS].m2x = m2x;
            results[iTacS].m2y = m2y;
            results[iTacS].m3x = m3x;
            results[iTacS].m3y = m3y;
            results[iTacS].m4x = m4x;
            results[iTacS].m4y = m4y;
            results[iTacS].m5x = m5x;
            results[iTacS].m5y = m5y;
            results[iTacS].m6x = m6x;
            results[iTacS].m6y = m6y;
            results[iTacS].m7x = m7x;
            results[iTacS].m7y = m7y;
            results[iTacS].m8x = m8x;
            results[iTacS].m8y = m8y;
            results[iTacS].m9x = m9x;
            results[iTacS].m9y = m9y;
            results[iTacS].m10x = m10x;
            results[iTacS].m10y = m10y;
            results[iTacS].m11x = m11x;
            results[iTacS].m11y = m11y;
            results[iTacS].m12x = m12x;
            results[iTacS].m12y = m12y;
            ++iTacS;
        }
        return results;
    }

    public HashMap<String, String> getScreentext() {
        HashMap<String, String> result = new HashMap<String, String>();
        String id = null;
        String text = null;
        Node[] nScreenText = this.parser.getNodes("screentext");
        int i = 0;
        while (i < nScreenText.length) {
            NamedNodeMap attr = nScreenText[i].getAttributes();
            id = attr.getNamedItem("id").getNodeValue();
            text = HelpMethods.replaceUmlauts(nScreenText[i].getTextContent());
            result.put(id, text);
            ++i;
        }
        return result;
    }

    public Spell[] getSpells() {
        Node[] nodes = this.parser.getNodes("spells");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("spell") == 0) {
                arNodes.add(subNodes[i]);
            }
            ++i;
        }
        Spell[] result = new Spell[arNodes.size()];
        int i2 = 0;
        while (i2 < arNodes.size()) {
            NamedNodeMap attr = ((Node)arNodes.get(i2)).getAttributes();
            result[i2] = new Spell(HelpMethods.replaceUmlauts(attr.getNamedItem("name").getNodeValue()), attr.getNamedItem("mp") != null ? Integer.parseInt(attr.getNamedItem("mp").getNodeValue()) : 0, attr.getNamedItem("effect").getNodeValue(), attr.getNamedItem("key") != null ? (char)attr.getNamedItem("key").getNodeValue().charAt(0) : (char)' ', attr.getNamedItem("strength") != null ? Integer.parseInt(attr.getNamedItem("strength").getNodeValue()) : 0);
            ++i2;
        }
        return result;
    }

    public HashMap<String, Object> getGameParams() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Node[] nodes = this.parser.getNodes("params");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("param") == 0) {
                arNodes.add(subNodes[i]);
            }
            ++i;
        }
        i = 0;
        while (i < arNodes.size()) {
            NamedNodeMap attr = ((Node)arNodes.get(i)).getAttributes();
            String paramName = attr.getNamedItem("name").getNodeValue();
            String paramType = attr.getNamedItem("type").getNodeValue();
            String strParamValue = attr.getNamedItem("value").getNodeValue();
            if (paramType.equalsIgnoreCase("int")) {
                result.put(paramName, Integer.valueOf(strParamValue));
            }
            if (paramType.equalsIgnoreCase("str")) {
                result.put(paramName, strParamValue);
            }
            ++i;
        }
        return result;
    }

    public HashMap<String, String> getCommonCittexts() {
        HashMap<String, String> result = new HashMap<String, String>();
        Node[] nodes = this.parser.getNodes("common_cittexts");
        Node[] subNodes = this.parser.getChildNodes(nodes[0]);
        ArrayList<Node> arNodes = new ArrayList<Node>();
        int i = 0;
        while (i < subNodes.length) {
            if (subNodes[i].getNodeName().compareTo("common_cittext") == 0) {
                arNodes.add(subNodes[i]);
            }
            ++i;
        }
        i = 0;
        while (i < arNodes.size()) {
            NamedNodeMap attr = ((Node)arNodes.get(i)).getAttributes();
            String key = HelpMethods.replaceUmlauts(attr.getNamedItem("key").getNodeValue());
            String text = HelpMethods.replaceUmlauts(attr.getNamedItem("text").getNodeValue());
            result.put(key, text);
            ++i;
        }
        return result;
    }
}

