/*
 * Decompiled with CFR 0.152.
 */
package sound;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundPlayer {
    private static final long serialVersionUID = -6986927812863544982L;
    boolean midi;
    Sequence sequence;
    public Sequencer sequencer;
    Clip clip;
    boolean playing = false;
    int audioLength;
    int audioPosition = 0;

    public SoundPlayer(URL url, boolean isMidi) throws IOException, UnsupportedAudioFileException, LineUnavailableException, MidiUnavailableException, InvalidMidiDataException {
        if (isMidi) {
            this.midi = true;
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequencer.setLoopCount(0);
            Synthesizer synth = MidiSystem.getSynthesizer();
            synth.open();
            this.sequence = MidiSystem.getSequence(url);
            this.sequencer.setSequence(this.sequence);
            this.audioLength = (int)this.sequence.getTickLength();
        } else {
            this.midi = false;
            AudioInputStream ain = AudioSystem.getAudioInputStream(url);
            try {
                DataLine.Info info = new DataLine.Info(Clip.class, ain.getFormat());
                this.clip = (Clip)AudioSystem.getLine(info);
                this.clip.open(ain);
            }
            finally {
                ain.close();
            }
            this.audioLength = (int)(this.clip.getMicrosecondLength() / 1000L);
        }
    }

    public SoundPlayer(File f, boolean isMidi) throws IOException, UnsupportedAudioFileException, LineUnavailableException, MidiUnavailableException, InvalidMidiDataException {
        if (isMidi) {
            this.midi = true;
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequencer.setLoopCount(-1);
            Synthesizer synth = MidiSystem.getSynthesizer();
            synth.open();
            this.sequence = MidiSystem.getSequence(f);
            this.sequencer.setSequence(this.sequence);
            this.audioLength = (int)this.sequence.getTickLength();
        } else {
            this.midi = false;
            AudioInputStream ain = AudioSystem.getAudioInputStream(f);
            try {
                DataLine.Info info = new DataLine.Info(Clip.class, ain.getFormat());
                this.clip = (Clip)AudioSystem.getLine(info);
                this.clip.open(ain);
            }
            finally {
                ain.close();
            }
            this.audioLength = (int)(this.clip.getMicrosecondLength() / 1000L);
        }
    }

    public void play() {
        if (this.midi) {
            this.sequencer.start();
        } else {
            this.clip.start();
        }
        this.playing = true;
    }

    public void stop() {
        if (this.midi) {
            this.sequencer.stop();
        } else {
            this.clip.stop();
        }
        this.playing = false;
    }

    public void reset() {
        this.stop();
        if (this.midi) {
            this.sequencer.setTickPosition(0L);
        } else {
            this.clip.setMicrosecondPosition(0L);
        }
        this.audioPosition = 0;
    }

    public void skip(int position) {
        if (position < 0 || position > this.audioLength) {
            return;
        }
        this.audioPosition = position;
        if (this.midi) {
            this.sequencer.setTickPosition(position);
        } else {
            this.clip.setMicrosecondPosition(position * 1000);
        }
    }

    public void playFromStart() {
        this.skip(0);
        this.play();
    }

    public int getLength() {
        return this.audioLength;
    }
}

